/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.mcpserver;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.lucenia.ml.common.action.mcpserver.LuceniaMcpStatelessServerTransportProvider;
import io.lucenia.ml.common.action.mcpserver.McpToolsHelper;
import io.lucenia.ml.common.action.mcpserver.PrivilegedObjectMapper;
import io.lucenia.ml.common.transport.mcpserver.requests.McpToolBaseInput;
import io.lucenia.ml.common.transport.mcpserver.requests.register.McpToolRegisterInput;
import io.modelcontextprotocol.server.McpServer;
import io.modelcontextprotocol.server.McpStatelessAsyncServer;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.McpStatelessServerTransport;
import io.skylite.common.action.ActionListener;
import io.skylite.common.collect.Tuple;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.client.Client;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.threadpool.ThreadPool;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class McpStatelessServerHolder {
    private static final Logger log = LoggerFactory.getLogger(McpStatelessServerHolder.class);
    private final McpToolsHelper mcpToolsHelper;
    private final Client client;
    private final ThreadPool threadPool;
    private static final int SYNC_MCP_TOOLS_JOB_INTERVAL = 10;
    public static Map<String, Long> IN_MEMORY_MCP_TOOLS = new ConcurrentHashMap<String, Long>();
    private static volatile McpStatelessAsyncServer mcpStatelessAsyncServer;
    private static volatile LuceniaMcpStatelessServerTransportProvider mcpStatelessServerTransportProvider;
    private static volatile Boolean initialized;

    public McpStatelessServerHolder(McpToolsHelper mcpToolsHelper, Client client, ThreadPool threadPool) {
        this.mcpToolsHelper = mcpToolsHelper;
        this.client = client;
        this.threadPool = threadPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        if (initialized.booleanValue()) {
            return;
        }
        Class<McpStatelessServerHolder> clazz = McpStatelessServerHolder.class;
        synchronized (McpStatelessServerHolder.class) {
            if (initialized.booleanValue()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            try {
                PrivilegedObjectMapper objectMapper = PrivilegedObjectMapper.create();
                mcpStatelessServerTransportProvider = new LuceniaMcpStatelessServerTransportProvider(objectMapper);
                McpSchema.ServerCapabilities serverCapabilities = McpSchema.ServerCapabilities.builder().tools(Boolean.valueOf(true)).logging().resources(Boolean.valueOf(false), Boolean.valueOf(false)).prompts(Boolean.valueOf(false)).build();
                log.info("Building MCP server ...");
                mcpStatelessAsyncServer = McpServer.async((McpStatelessServerTransport)mcpStatelessServerTransportProvider).serverInfo("Lucenia-MCP-Stateless-Server", "0.1.0").capabilities(serverCapabilities).instructions("Lucenia MCP Stateless Server - provides access to ML tools without sessions").objectMapper((ObjectMapper)objectMapper).build();
                log.info("Stateless MCP server created successfully");
                this.autoLoadAllMcpTools((ActionListener<Boolean>)ActionListener.wrap(success -> log.info("Initial tool loading completed successfully"), error -> log.error("Initial tool loading failed", (Throwable)error)));
                initialized = true;
            }
            catch (Exception e) {
                log.error("Failed to create stateless MCP server", (Throwable)e);
                throw new RuntimeException("Failed to create stateless MCP server", e);
            }
            return;
        }
    }

    public LuceniaMcpStatelessServerTransportProvider getMcpStatelessServerTransportProvider() {
        if (initialized.booleanValue()) {
            return mcpStatelessServerTransportProvider;
        }
        this.initialize();
        return mcpStatelessServerTransportProvider;
    }

    public McpStatelessAsyncServer getMcpStatelessAsyncServerInstance() {
        if (initialized.booleanValue()) {
            return mcpStatelessAsyncServer;
        }
        this.initialize();
        return mcpStatelessAsyncServer;
    }

    public void autoLoadAllMcpTools(ActionListener<Boolean> listener) {
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener restoreListener = ActionListener.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore());
            ActionListener searchListener = ActionListener.wrap(r -> {
                r.forEach((key, value) -> {
                    Long previousVersion = IN_MEMORY_MCP_TOOLS.putIfAbsent((String)key, (Long)value.v2());
                    if (previousVersion == null) {
                        this.getMcpStatelessAsyncServerInstance().addTool(this.mcpToolsHelper.createToolSpecification((McpToolBaseInput)value.v1())).doOnError(x -> {
                            IN_MEMORY_MCP_TOOLS.remove(key);
                            log.error("Failed to auto load tool: {}", (Object)((McpToolRegisterInput)value.v1()).getName(), x);
                        }).subscribe();
                    } else if (previousVersion < (Long)value.v2()) {
                        this.getMcpStatelessAsyncServerInstance().removeTool(key).onErrorResume(e -> {
                            log.warn("Failed to remove old tool version: {}", key, e);
                            return Mono.empty();
                        }).then(this.getMcpStatelessAsyncServerInstance().addTool(this.mcpToolsHelper.createToolSpecification((McpToolBaseInput)value.v1()))).doOnSuccess(x -> {
                            IN_MEMORY_MCP_TOOLS.put((String)key, (Long)value.v2());
                            log.info("Successfully updated tool: {} to version: {}", key, value.v2());
                        }).doOnError(x -> log.error("Failed to update tool: {} to version: {}", new Object[]{((McpToolRegisterInput)value.v1()).getName(), value.v2(), x})).subscribe();
                    }
                });
                this.startSyncMcpToolsJob();
                restoreListener.onResponse((Object)true);
            }, e -> {
                log.error("Failed to auto load all MCP tools to MCP server", (Throwable)e);
                restoreListener.onFailure(e);
            });
            this.mcpToolsHelper.searchAllToolsWithVersion((ActionListener<Map<String, Tuple<McpToolRegisterInput, Long>>>)searchListener);
        }
        catch (Exception e2) {
            log.error("Failed to auto load all MCP tools to MCP server", (Throwable)e2);
            listener.onFailure(e2);
        }
    }

    public void startSyncMcpToolsJob() {
        ActionListener listener = ActionListener.wrap(r -> log.debug("Auto reload mcp tools schedule job run successfully!"), e -> log.error(e.getMessage(), (Throwable)e));
        this.threadPool.schedule(() -> this.autoLoadAllMcpTools((ActionListener<Boolean>)listener), TimeValue.timeValueSeconds((long)10L), "lucenia_mcp_tools_sync");
    }

    static {
        initialized = false;
    }
}

