/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.mcpserver;

import com.google.gson.JsonElement;
import io.lucenia.ml.common.rest.mcpserver.ToolFactoryWrapper;
import io.lucenia.ml.common.transport.mcpserver.requests.McpToolBaseInput;
import io.lucenia.ml.common.transport.mcpserver.requests.register.McpToolRegisterInput;
import io.modelcontextprotocol.server.McpStatelessServerFeatures;
import io.modelcontextprotocol.spec.McpSchema;
import io.skylite.SkyliteException;
import io.skylite.common.action.ActionListener;
import io.skylite.common.collect.Tuple;
import io.skylite.common.xcontent.json.JsonXContent;
import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.client.Client;
import io.skylite.core.common.Strings;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.index.query.BoolQueryBuilder;
import io.skylite.core.index.query.MatchAllQueryBuilder;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.engine.tools.Tool;
import io.skylite.ml.common.systemindices.MLIndex;
import io.skylite.ml.common.utils.StringUtils;
import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.index.query.QueryBuilders;
import reactor.core.publisher.Mono;

public class McpToolsHelper {
    private static final Logger log = LogManager.getLogger(McpToolsHelper.class);
    public static final int MAX_TOOL_NUMBER = 1000;
    private final Client client;
    private final ToolFactoryWrapper toolFactoryWrapper;

    public McpToolsHelper(Client client, ToolFactoryWrapper toolFactoryWrapper) {
        this.client = client;
        this.toolFactoryWrapper = toolFactoryWrapper;
    }

    public McpStatelessServerFeatures.AsyncToolSpecification createToolSpecification(McpToolBaseInput tool) {
        String toolName = Optional.ofNullable(tool.getName()).orElse(tool.getType());
        Tool.Factory<?> factory = this.toolFactoryWrapper.getToolsFactories().get(tool.getType());
        if (factory == null) {
            throw new RuntimeException("Failed to find tool factory for tool type: " + tool.getType());
        }
        Tool actualTool = factory.create(Optional.ofNullable(tool.getParameters()).orElse(Map.of()));
        String schema = Optional.ofNullable(McpToolsHelper.getSchema(tool.getAttributes())).orElse(Optional.ofNullable(McpToolsHelper.getSchema(actualTool.getAttributes())).orElse("{}"));
        String description = Optional.ofNullable(tool.getDescription()).orElse(factory.getDefaultDescription());
        return AccessController.doPrivileged(() -> new McpStatelessServerFeatures.AsyncToolSpecification(new McpSchema.Tool(toolName, String.valueOf(description), schema), (ctx, request) -> Mono.create(sink -> {
            ActionListener actionListener = ActionListener.wrap(r -> sink.success((Object)new McpSchema.CallToolResult(List.of(new McpSchema.TextContent(r)), Boolean.valueOf(false))), e -> {
                log.error(() -> "Failed to execute tool, tool name: " + toolName, (Throwable)e);
                sink.error((Throwable)e);
            });
            actualTool.run(StringUtils.getParameterMap((Map)request.arguments()), actionListener);
        })));
    }

    private static String getSchema(Map<String, Object> attrs) {
        if (attrs == null || attrs.isEmpty()) {
            return null;
        }
        Object inputSchema = attrs.get("input_schema");
        if (inputSchema == null) {
            return null;
        }
        if (inputSchema instanceof String) {
            String inputSchemaString = (String)inputSchema;
            if ((inputSchemaString = inputSchemaString.trim()).isEmpty()) {
                return null;
            }
            return inputSchemaString;
        }
        if (inputSchema instanceof JsonElement) {
            JsonElement jsonElement = (JsonElement)inputSchema;
            return Strings.toJson((Object)jsonElement);
        }
        return Strings.toJson((Object)inputSchema);
    }

    public void searchAllTools(ActionListener<List<McpToolRegisterInput>> listener) {
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener restoreListener = ActionListener.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore());
            ActionListener actionListener = ActionListener.wrap(r -> {
                ArrayList mcpTools = new ArrayList();
                ArrayList errors = new ArrayList();
                Arrays.stream(Objects.requireNonNull(r.getHits().getHits())).forEach(x -> {
                    try {
                        McpToolRegisterInput mcpTool = this.parseMcpTool(x.getSourceAsString());
                        mcpTools.add(mcpTool);
                    }
                    catch (IOException e) {
                        errors.add(e);
                    }
                });
                if (!errors.isEmpty()) {
                    String errorMessage = String.format(Locale.ROOT, "Failed to parse %d out of %d MCP tools", errors.size(), r.getHits().getHits().length);
                    SkyliteException compositeException = new SkyliteException(errorMessage, new Object[0]);
                    for (IOException error : errors) {
                        compositeException.addSuppressed((Throwable)error);
                    }
                    log.error("Multiple parsing errors occurred: {}", (Object)errorMessage);
                    restoreListener.onFailure((Exception)compositeException);
                } else {
                    restoreListener.onResponse(mcpTools);
                }
            }, e -> {
                String errMsg = String.format(Locale.ROOT, "Failed to search mcp tools index with error: %s", e.getMessage());
                log.error(errMsg, (Throwable)e);
                restoreListener.onFailure((Exception)new SkyliteException(errMsg, new Object[0]));
            });
            this.client.search(this.buildSearchRequest(), actionListener);
        }
        catch (Exception e2) {
            log.error("Failed to search mcp tools index", (Throwable)e2);
            listener.onFailure(e2);
        }
    }

    public void searchToolsWithVersion(List<String> toolNames, ActionListener<List<McpToolRegisterInput>> listener) {
        ActionListener<SearchResponse> actionListener = this.createSearchResponseListener(listener);
        SearchRequest searchRequest = this.buildSearchRequest(toolNames);
        searchRequest.source().version(Boolean.valueOf(true));
        this.client.search(searchRequest, actionListener);
    }

    private ActionListener<SearchResponse> createSearchResponseListener(ActionListener<List<McpToolRegisterInput>> listener) {
        return ActionListener.wrap(r -> {
            ArrayList mcpTools = new ArrayList();
            ArrayList errors = new ArrayList();
            Arrays.stream(Objects.requireNonNull(r.getHits().getHits())).forEach(x -> {
                try {
                    McpToolRegisterInput mcpTool = this.parseMcpTool(x.getSourceAsString());
                    mcpTools.add(mcpTool);
                }
                catch (IOException e) {
                    errors.add(e);
                }
            });
            if (!errors.isEmpty()) {
                String errorMessage = String.format(Locale.ROOT, "Failed to parse %d out of %d MCP tools", errors.size(), r.getHits().getHits().length);
                SkyliteException compositeException = new SkyliteException(errorMessage, new Object[0]);
                for (IOException error : errors) {
                    compositeException.addSuppressed((Throwable)error);
                }
                log.error("Multiple parsing errors occurred: {}", (Object)errorMessage);
                listener.onFailure((Exception)compositeException);
            } else {
                listener.onResponse(mcpTools);
            }
        }, e -> {
            String errMsg = String.format(Locale.ROOT, "Failed to search mcp tools index with error: %s", e.getMessage());
            log.error(errMsg, (Throwable)e);
            listener.onFailure((Exception)new SkyliteException(errMsg, new Object[0]));
        });
    }

    public void searchToolsWithPrimaryTermAndSeqNo(List<String> toolNames, ActionListener<SearchResponse> listener) {
        SearchRequest searchRequest = this.buildSearchRequest(toolNames);
        searchRequest.source().seqNoAndPrimaryTerm(Boolean.valueOf(true));
        searchRequest.source().size(1000);
        this.client.search(searchRequest, listener);
    }

    public void searchAllToolsWithVersion(ActionListener<Map<String, Tuple<McpToolRegisterInput, Long>>> listener) {
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener restoreListener = ActionListener.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore());
            ActionListener actionListener = ActionListener.wrap(r -> {
                HashMap mcpTools = new HashMap();
                ArrayList errors = new ArrayList();
                Arrays.stream(Objects.requireNonNull(r.getHits().getHits())).forEach(x -> {
                    long version = x.getVersion();
                    try {
                        McpToolRegisterInput mcpTool = this.parseMcpTool(x.getSourceAsString());
                        mcpTools.put(mcpTool.getName(), Tuple.tuple((Object)mcpTool, (Object)version));
                    }
                    catch (IOException e) {
                        errors.add(e);
                    }
                });
                if (!errors.isEmpty()) {
                    String errorMessage = String.format(Locale.ROOT, "Failed to parse %d out of %d MCP tools", errors.size(), r.getHits().getHits().length);
                    SkyliteException compositeException = new SkyliteException(errorMessage, new Object[0]);
                    for (IOException error : errors) {
                        compositeException.addSuppressed((Throwable)error);
                    }
                    log.error("Multiple parsing errors occurred: {}", (Object)errorMessage);
                    restoreListener.onFailure((Exception)compositeException);
                } else {
                    restoreListener.onResponse(mcpTools);
                }
            }, e -> {
                String errMsg = String.format(Locale.ROOT, "Failed to search mcp tools index with error: %s", e.getMessage());
                log.error(errMsg, (Throwable)e);
                restoreListener.onFailure((Exception)new SkyliteException(errMsg, new Object[0]));
            });
            this.client.search(this.buildSearchRequest(), actionListener);
        }
        catch (Exception e2) {
            log.error("Failed to search mcp tools index", (Throwable)e2);
            listener.onFailure(e2);
        }
    }

    private SearchRequest buildSearchRequest() {
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.indices(new String[]{MLIndex.MCP_TOOLS.getIndexName()});
        MatchAllQueryBuilder queryBuilder = QueryBuilders.matchAllQuery();
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.version(Boolean.valueOf(true));
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        searchRequest.source(searchSourceBuilder);
        searchRequest.source().size(1000);
        return searchRequest;
    }

    private SearchRequest buildSearchRequest(List<String> toolNames) {
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.indices(new String[]{MLIndex.MCP_TOOLS.getIndexName()});
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        toolNames.forEach(toolName -> queryBuilder.should((QueryBuilder)QueryBuilders.matchQuery((String)"name", (Object)toolName)));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        searchRequest.source(searchSourceBuilder);
        searchRequest.source().size(1000);
        return searchRequest;
    }

    private McpToolRegisterInput parseMcpTool(String input) throws IOException {
        McpToolRegisterInput mcpToolRegisterInput;
        block8: {
            XContentParser parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, input);
            try {
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                mcpToolRegisterInput = McpToolRegisterInput.parse(parser);
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.error("Failed to parse mcp tools configuration: {}", (Object)input);
                    throw e;
                }
            }
            parser.close();
        }
        return mcpToolRegisterInput;
    }
}

