/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.mcpserver;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class PrivilegedObjectMapper
extends ObjectMapper {
    public static PrivilegedObjectMapper create() {
        JsonMapper.Builder builder = (JsonMapper.Builder)JsonMapper.builder().addModule((Module)new ParameterNamesModule());
        PrivilegedObjectMapper mapper = new PrivilegedObjectMapper(builder.build());
        SimpleModule privilegedModule = new SimpleModule("PrivilegedRecordModule");
        mapper.registerModule((Module)privilegedModule);
        return mapper;
    }

    private PrivilegedObjectMapper(ObjectMapper base) {
        super(base);
    }

    public <T> T readValue(final String content, final Class<T> valueType) {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<T>(){

                @Override
                public T run() throws Exception {
                    return PrivilegedObjectMapper.super.readValue(content, valueType);
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException("Privileged deserialization failed", cause);
        }
    }

    public <T> T readValue(final JsonParser p, final Class<T> valueType) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<T>(){

                @Override
                public T run() throws IOException {
                    return PrivilegedObjectMapper.super.readValue(p, valueType);
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new IOException("Privileged deserialization failed", cause);
        }
    }

    public <T> T readValue(final JsonParser p, final JavaType valueType) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<T>(){

                @Override
                public T run() throws IOException {
                    return PrivilegedObjectMapper.super.readValue(p, valueType);
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new IOException("Privileged deserialization failed", cause);
        }
    }

    protected Object _readMapAndClose(final JsonParser p0, final JavaType valueType) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws IOException {
                    return PrivilegedObjectMapper.super._readMapAndClose(p0, valueType);
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new IOException("Privileged deserialization failed", cause);
        }
    }

    public String writeValueAsString(final Object value) {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    return PrivilegedObjectMapper.super.writeValueAsString(value);
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException("Privileged serialization failed", cause);
        }
    }

    public <T> T convertValue(final Object fromValue, final Class<T> toValueType) {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<T>(){

                @Override
                public T run() throws Exception {
                    return PrivilegedObjectMapper.super.convertValue(fromValue, toValueType);
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException("Privileged conversion failed", cause);
        }
    }

    public <T> T convertValue(final Object fromValue, final JavaType toValueType) {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<T>(){

                @Override
                public T run() throws Exception {
                    return PrivilegedObjectMapper.super.convertValue(fromValue, toValueType);
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException("Privileged conversion failed", cause);
        }
    }

    public <T> T convertValue(final Object fromValue, final TypeReference<T> toValueTypeRef) {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<T>(){

                @Override
                public T run() throws Exception {
                    return PrivilegedObjectMapper.super.convertValue(fromValue, toValueTypeRef);
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException("Privileged conversion failed", cause);
        }
    }
}

