/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.mcpserver;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.lucenia.ml.common.action.mcpserver.LuceniaMcpStatelessServerTransportProvider;
import io.lucenia.ml.common.action.mcpserver.McpStatelessServerHolder;
import io.lucenia.ml.common.action.mcpserver.PrivilegedObjectMapper;
import io.lucenia.ml.common.transport.mcpserver.requests.server.MLMcpServerRequest;
import io.lucenia.ml.common.transport.mcpserver.requests.server.MLMcpServerResponse;
import io.modelcontextprotocol.spec.McpSchema;
import io.skylite.SkyliteException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.ml.common.settings.MLCommonsSettings;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import java.security.AccessController;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransportMcpServerAction
extends HandledTransportAction<ActionRequest, MLMcpServerResponse> {
    private static final Logger log = LogManager.getLogger(TransportMcpServerAction.class);
    MLFeatureEnabledSetting mlFeatureEnabledSetting;
    ObjectMapper objectMapper;
    McpStatelessServerHolder mcpStatelessServerHolder;

    @Inject
    public TransportMcpServerAction(TransportService transportService, ActionFilters actionFilters, MLFeatureEnabledSetting mlFeatureEnabledSetting, McpStatelessServerHolder mcpStatelessServerHolder) {
        super("cluster:admin/lucenia/ml/mcp/server", transportService, actionFilters, MLMcpServerRequest::new);
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
        this.objectMapper = PrivilegedObjectMapper.create();
        this.mcpStatelessServerHolder = mcpStatelessServerHolder;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<MLMcpServerResponse> listener) {
        try {
            McpSchema.JSONRPCMessage message;
            if (!this.mlFeatureEnabledSetting.isMcpServerEnabled()) {
                listener.onFailure((Exception)new SkyliteException(MLCommonsSettings.ML_COMMONS_MCP_SERVER_DISABLED_MESSAGE, new Object[0]));
                return;
            }
            MLMcpServerRequest mlMcpServerRequest = MLMcpServerRequest.fromActionRequest(request);
            LuceniaMcpStatelessServerTransportProvider transportProvider = this.mcpStatelessServerHolder.getMcpStatelessServerTransportProvider();
            if (transportProvider == null) {
                log.error("MCP handler not ready - server initialization failed");
                this.handleError(null, -32000, "MCP transport provider not ready - server may not be properly initialized", listener);
                return;
            }
            try {
                String requestBody = mlMcpServerRequest.getRequestBody();
                log.debug("MCP JSON-RPC Request Body: {}", (Object)requestBody);
                log.debug("ObjectMapper configuration: modules={}, features={}", (Object)this.objectMapper.getRegisteredModuleIds(), (Object)this.objectMapper.getDeserializationConfig().getDeserializationFeatures());
                message = AccessController.doPrivileged(() -> {
                    try {
                        return McpSchema.deserializeJsonRpcMessage((ObjectMapper)this.objectMapper, (String)requestBody);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                });
                log.debug("Successfully parsed JSON-RPC message: type={}, method={}", (Object)message.getClass().getSimpleName(), (Object)(message instanceof McpSchema.JSONRPCRequest ? ((McpSchema.JSONRPCRequest)message).method() : "N/A"));
            }
            catch (Exception e) {
                log.error("Parse error details - Exception type: {}, Message: {}", (Object)e.getClass().getName(), (Object)e.getMessage());
                log.error("Request body that failed to parse: {}", (Object)mlMcpServerRequest.getRequestBody());
                this.handleError(null, -32700, "Parse error: " + e.getMessage(), listener);
                return;
            }
            if (message instanceof McpSchema.JSONRPCNotification) {
                listener.onResponse((Object)new MLMcpServerResponse(true, null, null));
                return;
            }
            Object id = message instanceof McpSchema.JSONRPCRequest ? ((McpSchema.JSONRPCRequest)message).id() : null;
            transportProvider.handleRequest(message).subscribe(response -> {
                try {
                    String responseJson = AccessController.doPrivileged(() -> {
                        try {
                            return this.objectMapper.writeValueAsString(response);
                        }
                        catch (JsonProcessingException e) {
                            throw new RuntimeException(e);
                        }
                    });
                    listener.onResponse((Object)new MLMcpServerResponse(true, responseJson, null));
                }
                catch (Exception e) {
                    log.error("Response serialization failed: " + e.getMessage(), (Throwable)e);
                    this.handleError(id, -32603, "Response serialization failed: " + e.getMessage(), listener);
                }
            }, error -> {
                log.error("Internal server error: " + error.getMessage(), error);
                this.handleError(id, -32603, "Internal server error: " + error.getMessage(), listener);
            });
        }
        catch (Exception e) {
            log.error("Failed to handle stateless MCP request", (Throwable)e);
            this.handleError(null, -32603, "Internal server error: " + e.getMessage(), listener);
        }
    }

    private void handleError(Object id, int errorCode, String responseMessage, ActionListener<MLMcpServerResponse> listener) {
        HashMap<String, Object> errorMessage = new HashMap<String, Object>();
        errorMessage.put("message", responseMessage);
        errorMessage.put("id", id);
        errorMessage.put("error_code", errorCode);
        listener.onResponse((Object)new MLMcpServerResponse(false, null, errorMessage));
    }
}

