/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.mcpserver;

import io.lucenia.ml.common.action.mcpserver.McpToolsHelper;
import io.lucenia.ml.common.transport.mcpserver.requests.list.MLMcpToolsListRequest;
import io.lucenia.ml.common.transport.mcpserver.requests.register.McpToolRegisterInput;
import io.lucenia.ml.common.transport.mcpserver.responses.list.MLMcpToolsListResponse;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.ml.common.cluster.DiscoveryNodeHelper;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransportMcpToolsListAction
extends HandledTransportAction<ActionRequest, MLMcpToolsListResponse> {
    private static final Logger log = LogManager.getLogger(TransportMcpToolsListAction.class);
    private final McpToolsHelper mcpToolsHelper;
    TransportService transportService;
    ClusterService clusterService;
    NamedXContentRegistry xContentRegistry;
    DiscoveryNodeHelper nodeFilter;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    @Inject
    public TransportMcpToolsListAction(TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, NamedXContentRegistry xContentRegistry, DiscoveryNodeHelper nodeFilter, McpToolsHelper mcpToolsHelper, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/lucenia/ml/mcp_tools/list", transportService, actionFilters, MLMcpToolsListRequest::new);
        this.xContentRegistry = xContentRegistry;
        this.nodeFilter = nodeFilter;
        this.mcpToolsHelper = mcpToolsHelper;
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<MLMcpToolsListResponse> listener) {
        if (!this.mlFeatureEnabledSetting.isMcpServerEnabled()) {
            listener.onFailure((Exception)new IllegalStateException("The MCP server is not enabled. To enable, please update the setting plugins.ml_commons.mcp_server_enabled"));
            return;
        }
        try {
            this.mcpToolsHelper.searchAllTools((ActionListener<List<McpToolRegisterInput>>)ActionListener.wrap(tools -> {
                log.info("Listed {} MCP tools", (Object)tools.size());
                listener.onResponse((Object)new MLMcpToolsListResponse((List<McpToolRegisterInput>)tools));
            }, e -> {
                log.error("Failed to list MCP tools", (Throwable)e);
                listener.onFailure(e);
            }));
        }
        catch (Exception e2) {
            log.error("Failed to list MCP tools", (Throwable)e2);
            listener.onFailure(e2);
        }
    }
}

