/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.mcpserver;

import io.lucenia.action.support.nodes.TransportNodesAction;
import io.lucenia.ml.common.action.mcpserver.McpStatelessServerHolder;
import io.lucenia.ml.common.action.mcpserver.McpToolsHelper;
import io.lucenia.ml.common.rest.mcpserver.ToolFactoryWrapper;
import io.lucenia.ml.common.transport.mcpserver.requests.McpToolBaseInput;
import io.lucenia.ml.common.transport.mcpserver.requests.register.MLMcpToolsRegisterNodeRequest;
import io.lucenia.ml.common.transport.mcpserver.requests.register.MLMcpToolsRegisterNodesRequest;
import io.lucenia.ml.common.transport.mcpserver.requests.register.McpToolRegisterInput;
import io.lucenia.ml.common.transport.mcpserver.responses.register.MLMcpToolsRegisterNodeResponse;
import io.lucenia.ml.common.transport.mcpserver.responses.register.MLMcpToolsRegisterNodesResponse;
import io.skylite.SkyliteException;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.FailedNodeException;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.NamedXContentRegistry;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class TransportMcpToolsRegisterOnNodesAction
extends TransportNodesAction<MLMcpToolsRegisterNodesRequest, MLMcpToolsRegisterNodesResponse, MLMcpToolsRegisterNodeRequest, MLMcpToolsRegisterNodeResponse> {
    Logger log = LogManager.getLogger(TransportMcpToolsRegisterOnNodesAction.class);
    TransportService transportService;
    ClusterService clusterService;
    ThreadPool threadPool;
    Client client;
    NamedXContentRegistry xContentRegistry;
    ToolFactoryWrapper toolFactoryWrapper;
    McpToolsHelper mcpToolsHelper;
    McpStatelessServerHolder mcpStatelessServerHolder;

    @Inject
    public TransportMcpToolsRegisterOnNodesAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, ThreadPool threadPool, Client client, NamedXContentRegistry xContentRegistry, ToolFactoryWrapper toolFactoryWrapper, McpToolsHelper mcpToolsHelper, McpStatelessServerHolder mcpStatelessServerHolder) {
        super("cluster:admin/lucenia/ml/mcp_tools/register_on_nodes", threadPool, clusterService, transportService, actionFilters, MLMcpToolsRegisterNodesRequest::new, MLMcpToolsRegisterNodeRequest::new, "management", MLMcpToolsRegisterNodeResponse.class);
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.toolFactoryWrapper = toolFactoryWrapper;
        this.mcpToolsHelper = mcpToolsHelper;
        this.mcpStatelessServerHolder = mcpStatelessServerHolder;
    }

    protected MLMcpToolsRegisterNodesResponse newResponse(MLMcpToolsRegisterNodesRequest nodesRequest, List<MLMcpToolsRegisterNodeResponse> responses, List<FailedNodeException> failures) {
        return new MLMcpToolsRegisterNodesResponse(this.clusterService.getClusterName(), responses, failures);
    }

    protected MLMcpToolsRegisterNodeRequest newNodeRequest(MLMcpToolsRegisterNodesRequest request) {
        return new MLMcpToolsRegisterNodeRequest(request.getMcpTools());
    }

    protected MLMcpToolsRegisterNodeResponse newNodeResponse(StreamInput in) throws IOException {
        return new MLMcpToolsRegisterNodeResponse(in);
    }

    protected MLMcpToolsRegisterNodeResponse nodeOperation(MLMcpToolsRegisterNodeRequest request) {
        return this.registerToolsOnNode(request.getMcpTools());
    }

    private MLMcpToolsRegisterNodeResponse registerToolsOnNode(List<McpToolRegisterInput> mcpTools) {
        AtomicReference exception = new AtomicReference();
        Flux.fromStream(mcpTools.stream()).flatMap(tool -> {
            Long previousVersion = McpStatelessServerHolder.IN_MEMORY_MCP_TOOLS.putIfAbsent(tool.getName(), tool.getVersion());
            if (previousVersion == null) {
                return this.mcpStatelessServerHolder.getMcpStatelessAsyncServerInstance().addTool(this.mcpToolsHelper.createToolSpecification((McpToolBaseInput)tool)).doOnError(x -> McpStatelessServerHolder.IN_MEMORY_MCP_TOOLS.remove(tool.getName()));
            }
            return Mono.empty();
        }).doOnError(e -> {
            this.log.error("Failed to register tool: {} in MCP server memory on node: {}", mcpTools.stream().map(McpToolBaseInput::getName).toList(), (Object)this.clusterService.localNode().getId());
            exception.set(e);
        }).doOnComplete(() -> this.log.debug("Successfully register tools on node: {}", (Object)this.clusterService.localNode().getId())).subscribe();
        if (exception.get() != null) {
            String errorMsg = ((Throwable)exception.get()).getMessage();
            throw new FailedNodeException(this.clusterService.localNode().getId(), errorMsg, (Throwable)new SkyliteException(errorMsg, new Object[0]));
        }
        return new MLMcpToolsRegisterNodeResponse(this.clusterService.localNode(), true);
    }
}

