/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.mcpserver;

import io.lucenia.ml.common.action.mcpserver.McpToolsHelper;
import io.lucenia.ml.common.transport.mcpserver.action.MLMcpToolsRemoveOnNodesAction;
import io.lucenia.ml.common.transport.mcpserver.requests.McpToolBaseInput;
import io.lucenia.ml.common.transport.mcpserver.requests.register.McpToolRegisterInput;
import io.lucenia.ml.common.transport.mcpserver.requests.remove.MLMcpToolsRemoveNodesRequest;
import io.lucenia.ml.common.transport.mcpserver.responses.remove.MLMcpToolsRemoveNodesResponse;
import io.skylite.SkyliteException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.WriteRequest;
import io.skylite.core.action.bulk.BulkRequest;
import io.skylite.core.action.delete.DeleteRequest;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.tasks.Task;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.ml.common.cluster.DiscoveryNodeHelper;
import io.skylite.ml.common.settings.MLCommonsSettings;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import io.skylite.ml.common.systemindices.MLIndex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransportMcpToolsRemoveAction
extends HandledTransportAction<ActionRequest, MLMcpToolsRemoveNodesResponse> {
    static final Logger log = LogManager.getLogger(TransportMcpToolsRemoveAction.class);
    TransportService transportService;
    ClusterService clusterService;
    ThreadPool threadPool;
    Client client;
    NamedXContentRegistry xContentRegistry;
    DiscoveryNodeHelper nodeFilter;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;
    private final McpToolsHelper mcpToolsHelper;

    @Inject
    public TransportMcpToolsRemoveAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, ThreadPool threadPool, Client client, NamedXContentRegistry xContentRegistry, DiscoveryNodeHelper nodeFilter, McpToolsHelper mcpToolsHelper, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/lucenia/ml/mcp_tools/remove", transportService, actionFilters, MLMcpToolsRemoveNodesRequest::new);
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.nodeFilter = nodeFilter;
        this.mcpToolsHelper = mcpToolsHelper;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<MLMcpToolsRemoveNodesResponse> listener) {
        if (!this.mlFeatureEnabledSetting.isMcpServerEnabled()) {
            listener.onFailure((Exception)new SkyliteException(MLCommonsSettings.ML_COMMONS_MCP_SERVER_DISABLED_MESSAGE, new Object[0]));
            return;
        }
        MLMcpToolsRemoveNodesRequest removeToolsOnNodesRequest = (MLMcpToolsRemoveNodesRequest)request;
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener restoreListener = ActionListener.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore());
            ActionListener searchResultListener = ActionListener.wrap(searchResult -> {
                if (!searchResult.isEmpty()) {
                    List<String> foundTools = searchResult.stream().map(McpToolBaseInput::getName).toList();
                    ArrayList<String> remainingTools = new ArrayList<String>(removeToolsOnNodesRequest.getMcpTools());
                    foundTools.forEach(remainingTools::remove);
                    if (!remainingTools.isEmpty()) {
                        String exceptionMessage = String.format(Locale.ROOT, "Unable to remove tools as these tools: %s are not found in system index", remainingTools);
                        log.info(exceptionMessage);
                        restoreListener.onFailure((Exception)new SkyliteException(exceptionMessage, new Object[0]));
                    } else {
                        this.bulkDeleteMcpTools(removeToolsOnNodesRequest, foundTools, (ActionListener<MLMcpToolsRemoveNodesResponse>)restoreListener);
                    }
                } else {
                    String exceptionMessage = "Unable to remove tools as no tool in the request found in system index";
                    log.warn(exceptionMessage);
                    restoreListener.onFailure((Exception)new SkyliteException(exceptionMessage, new Object[0]));
                }
            }, e -> {
                log.error("Failed to search mcp tools index", (Throwable)e);
                restoreListener.onFailure(e);
            });
            this.mcpToolsHelper.searchToolsWithVersion(removeToolsOnNodesRequest.getMcpTools(), (ActionListener<List<McpToolRegisterInput>>)searchResultListener);
        }
        catch (Exception e2) {
            log.error("Failed to remove mcp tools caused by system internal error", (Throwable)e2);
            listener.onFailure(e2);
        }
    }

    private void bulkDeleteMcpTools(MLMcpToolsRemoveNodesRequest removeToolsOnNodesRequest, List<String> foundTools, ActionListener<MLMcpToolsRemoveNodesResponse> listener) {
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener restoreListener = ActionListener.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore());
            ActionListener bulkResultListener = ActionListener.wrap(bulkResponse -> {
                if (!bulkResponse.hasFailures()) {
                    this.removeMcpToolsInMemory(removeToolsOnNodesRequest, new StringBuilder(), foundTools, (ActionListener<MLMcpToolsRemoveNodesResponse>)restoreListener);
                } else {
                    StringBuilder errMsgBuilder = new StringBuilder();
                    ArrayList<String> removeSucceedTools = new ArrayList<String>();
                    Arrays.stream(bulkResponse.getItems()).forEach(x -> {
                        if (x.isFailed()) {
                            errMsgBuilder.append(String.format(Locale.ROOT, "Failed to remove tool: %s from index with error: %s", x.getId(), x.getFailure().getMessage()));
                            errMsgBuilder.append("\n");
                        } else {
                            removeSucceedTools.add(x.getId());
                        }
                    });
                    removeToolsOnNodesRequest.setMcpTools(removeSucceedTools);
                    this.removeMcpToolsInMemory(removeToolsOnNodesRequest, errMsgBuilder, removeSucceedTools, (ActionListener<MLMcpToolsRemoveNodesResponse>)restoreListener);
                }
            }, e -> {
                log.error("Failed to delete MCP tools in index", (Throwable)e);
                restoreListener.onFailure(e);
            });
            BulkRequest bulkRequest = new BulkRequest();
            bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            for (String name : foundTools) {
                DeleteRequest deleteRequest = new DeleteRequest(MLIndex.MCP_TOOLS.getIndexName(), name);
                bulkRequest.add(deleteRequest);
            }
            this.client.bulk(bulkRequest, bulkResultListener);
        }
        catch (Exception e2) {
            log.error("Failed to remove mcp tools", (Throwable)e2);
            listener.onFailure(e2);
        }
    }

    private void removeMcpToolsInMemory(MLMcpToolsRemoveNodesRequest removeToolsOnNodesRequest, StringBuilder errMsgBuilder, List<String> removeSucceedTools, ActionListener<MLMcpToolsRemoveNodesResponse> listener) {
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener restoreListener = ActionListener.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore());
            ActionListener removeFromMemoryResultListener = ActionListener.wrap(r -> {
                if (r.failures() != null && !r.failures().isEmpty()) {
                    r.failures().forEach(x -> {
                        errMsgBuilder.append(String.format(Locale.ROOT, "Tools: %s are removed successfully in index but failed to remove from mcp server in memory with error: %s", removeSucceedTools, x.getRootCause().getMessage()));
                        errMsgBuilder.append("\n");
                    });
                    errMsgBuilder.deleteCharAt(errMsgBuilder.length() - 1);
                    log.error(errMsgBuilder.toString());
                    restoreListener.onFailure((Exception)new SkyliteException(errMsgBuilder.toString(), new Object[0]));
                } else if (errMsgBuilder.isEmpty()) {
                    restoreListener.onResponse((Object)r);
                } else {
                    restoreListener.onFailure((Exception)new SkyliteException(errMsgBuilder.deleteCharAt(errMsgBuilder.length() - 1).toString(), new Object[0]));
                }
            }, e -> {
                errMsgBuilder.append(String.format(Locale.ROOT, "Tools are removed successfully in index but failed to remove from mcp server memory with error: %s", e.getMessage()));
                log.error(errMsgBuilder.toString(), (Throwable)e);
                restoreListener.onFailure((Exception)new SkyliteException(errMsgBuilder.toString(), new Object[0]));
            });
            removeToolsOnNodesRequest.setMcpTools(removeSucceedTools);
            this.client.execute((ActionType)MLMcpToolsRemoveOnNodesAction.INSTANCE, (ActionRequest)removeToolsOnNodesRequest, removeFromMemoryResultListener);
        }
        catch (Exception e2) {
            String errMsg = String.format(Locale.ROOT, "Failed to remove mcp tools on nodes memory with error: %s", e2.getMessage());
            log.error(errMsg, (Throwable)e2);
            listener.onFailure((Exception)new SkyliteException(errMsg, new Object[0]));
        }
    }
}

