/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.mcpserver;

import io.lucenia.action.support.nodes.TransportNodesAction;
import io.lucenia.ml.common.action.mcpserver.McpStatelessServerHolder;
import io.lucenia.ml.common.action.mcpserver.McpToolsHelper;
import io.lucenia.ml.common.rest.mcpserver.ToolFactoryWrapper;
import io.lucenia.ml.common.transport.mcpserver.requests.McpToolBaseInput;
import io.lucenia.ml.common.transport.mcpserver.requests.update.MLMcpToolsUpdateNodeRequest;
import io.lucenia.ml.common.transport.mcpserver.requests.update.MLMcpToolsUpdateNodesRequest;
import io.lucenia.ml.common.transport.mcpserver.requests.update.McpToolUpdateInput;
import io.lucenia.ml.common.transport.mcpserver.responses.update.MLMcpToolsUpdateNodeResponse;
import io.lucenia.ml.common.transport.mcpserver.responses.update.MLMcpToolsUpdateNodesResponse;
import io.modelcontextprotocol.server.McpStatelessAsyncServer;
import io.skylite.SkyliteException;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.FailedNodeException;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.NamedXContentRegistry;
import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class TransportMcpToolsUpdateOnNodesAction
extends TransportNodesAction<MLMcpToolsUpdateNodesRequest, MLMcpToolsUpdateNodesResponse, MLMcpToolsUpdateNodeRequest, MLMcpToolsUpdateNodeResponse> {
    private static final Logger log = LogManager.getLogger(TransportMcpToolsUpdateOnNodesAction.class);
    TransportService transportService;
    ClusterService clusterService;
    ThreadPool threadPool;
    Client client;
    NamedXContentRegistry xContentRegistry;
    ToolFactoryWrapper toolFactoryWrapper;
    McpToolsHelper mcpToolsHelper;
    McpStatelessServerHolder mcpStatelessServerHolder;

    @Inject
    public TransportMcpToolsUpdateOnNodesAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, ThreadPool threadPool, Client client, NamedXContentRegistry xContentRegistry, ToolFactoryWrapper toolFactoryWrapper, McpToolsHelper mcpToolsHelper, McpStatelessServerHolder mcpStatelessServerHolder) {
        super("cluster:admin/lucenia/ml/mcp_tools/update_on_nodes", threadPool, clusterService, transportService, actionFilters, MLMcpToolsUpdateNodesRequest::new, MLMcpToolsUpdateNodeRequest::new, "management", MLMcpToolsUpdateNodeResponse.class);
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.toolFactoryWrapper = toolFactoryWrapper;
        this.mcpToolsHelper = mcpToolsHelper;
        this.mcpStatelessServerHolder = mcpStatelessServerHolder;
    }

    protected MLMcpToolsUpdateNodesResponse newResponse(MLMcpToolsUpdateNodesRequest nodesRequest, List<MLMcpToolsUpdateNodeResponse> responses, List<FailedNodeException> failures) {
        return new MLMcpToolsUpdateNodesResponse(this.clusterService.getClusterName(), responses, failures);
    }

    protected MLMcpToolsUpdateNodeRequest newNodeRequest(MLMcpToolsUpdateNodesRequest request) {
        return new MLMcpToolsUpdateNodeRequest(request.getMcpTools());
    }

    protected MLMcpToolsUpdateNodeResponse newNodeResponse(StreamInput in) throws IOException {
        return new MLMcpToolsUpdateNodeResponse(in);
    }

    protected MLMcpToolsUpdateNodeResponse nodeOperation(MLMcpToolsUpdateNodeRequest request) {
        return this.updateToolsOnNode(request.getMcpTools());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MLMcpToolsUpdateNodeResponse updateToolsOnNode(List<McpToolUpdateInput> mcpTools) {
        McpStatelessAsyncServer mcpStatelessAsyncServer = this.mcpStatelessServerHolder.getMcpStatelessAsyncServerInstance();
        synchronized (mcpStatelessAsyncServer) {
            try {
                Flux.fromStream(mcpTools.stream()).flatMap(tool -> {
                    McpStatelessServerHolder.IN_MEMORY_MCP_TOOLS.remove(tool.getName());
                    return this.mcpStatelessServerHolder.getMcpStatelessAsyncServerInstance().removeTool(tool.getName()).onErrorResume(e -> Mono.empty()).then(Mono.defer(() -> this.mcpStatelessServerHolder.getMcpStatelessAsyncServerInstance().addTool(this.mcpToolsHelper.createToolSpecification((McpToolBaseInput)tool)))).doOnSuccess(x -> McpStatelessServerHolder.IN_MEMORY_MCP_TOOLS.put(tool.getName(), tool.getVersion()));
                }).doOnComplete(() -> log.debug("Successfully Update tools on node: {}", (Object)this.clusterService.localNode().getId())).blockLast();
            }
            catch (Exception e) {
                log.error("Failed to Update tools: {} in MCP server memory on node: {}", mcpTools.stream().map(McpToolBaseInput::getName).toList(), (Object)this.clusterService.localNode().getId());
                String errorMsg = e.getMessage();
                throw new FailedNodeException(this.clusterService.localNode().getId(), errorMsg, (Throwable)new SkyliteException(errorMsg, new Object[0]));
            }
        }
        return new MLMcpToolsUpdateNodeResponse(this.clusterService.localNode(), true);
    }
}

