/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.memory.conversation;

import io.skylite.SkyliteParseException;
import io.skylite.Version;
import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.ml.common.CommonValue;
import java.io.IOException;
import java.util.Map;

public class CreateConversationRequest
extends ActionRequest {
    public static final Version<?> MINIMAL_SUPPORTED_VERSION_FOR_ADDITIONAL_INFO = CommonValue.VERSION_2_17_0;
    private String name = null;
    private String applicationType = null;
    private Map<String, String> additionalInfos = null;

    public CreateConversationRequest(StreamInput in) throws IOException {
        super(in);
        this.name = in.readOptionalString();
        this.applicationType = in.readOptionalString();
        if (in.getVersion().onOrAfter(MINIMAL_SUPPORTED_VERSION_FOR_ADDITIONAL_INFO) && in.readBoolean()) {
            this.additionalInfos = in.readMap(StreamInput::readString, StreamInput::readString);
        }
    }

    public CreateConversationRequest(String name) {
        this.name = name;
    }

    public CreateConversationRequest(String name, String applicationType) {
        this.name = name;
        this.applicationType = applicationType;
    }

    public CreateConversationRequest(String name, String applicationType, Map<String, String> additionalInfos) {
        this.name = name;
        this.applicationType = applicationType;
        this.additionalInfos = additionalInfos;
    }

    public CreateConversationRequest() {
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.name);
        out.writeOptionalString(this.applicationType);
        if (out.getVersion().onOrAfter(MINIMAL_SUPPORTED_VERSION_FOR_ADDITIONAL_INFO)) {
            if (this.additionalInfos == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeMap(this.additionalInfos, StreamOutput::writeString, StreamOutput::writeString);
            }
        }
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException exception = null;
        return exception;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CreateConversationRequest fromRestRequest(RestRequest restRequest) throws IOException {
        if (!restRequest.hasContent()) {
            return new CreateConversationRequest();
        }
        try (XContentParser parser = restRequest.contentParser();){
            Map body = parser.map();
            String name = null;
            String applicationType = null;
            Map additionalInfo = null;
            Object object = body.keySet().iterator();
            block18: while (object.hasNext()) {
                String key;
                switch (key = (String)object.next()) {
                    case "name": {
                        name = (String)body.get("name");
                        continue block18;
                    }
                    case "application_type": {
                        applicationType = (String)body.get("application_type");
                        continue block18;
                    }
                    case "additional_info": {
                        additionalInfo = (Map)body.get("additional_info");
                        continue block18;
                    }
                }
                parser.skipChildren();
            }
            if (body.get("name") != null) {
                object = new CreateConversationRequest(name, applicationType, additionalInfo);
                return object;
            }
            object = new CreateConversationRequest();
            return object;
        }
        catch (Exception exception) {
            throw new SkyliteParseException(exception.getMessage(), new Object[0]);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getApplicationType() {
        return this.applicationType;
    }

    public Map<String, String> getAdditionalInfos() {
        return this.additionalInfos;
    }
}

