/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.memory.conversation;

import io.lucenia.ml.common.action.memory.conversation.CreateConversationRequest;
import io.lucenia.ml.common.action.memory.conversation.CreateConversationResponse;
import io.lucenia.ml.common.conversation.ConversationalSearchService;
import io.skylite.SkyliteException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.ml.common.conversation.ConversationalIndexConstants;
import io.skylite.ml.common.conversation.ConversationalMemoryHandler;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CreateConversationTransportAction
extends HandledTransportAction<CreateConversationRequest, CreateConversationResponse> {
    private static final Logger log = LogManager.getLogger(CreateConversationTransportAction.class);
    private ConversationalMemoryHandler cmHandler;
    private Client client;
    private volatile boolean featureIsEnabled;

    @Inject
    public CreateConversationTransportAction(TransportService transportService, ActionFilters actionFilters, ConversationalSearchService cmHandler, Client client, ClusterService clusterService) {
        super("cluster:admin/lucenia/ml/memory/conversation/create", transportService, actionFilters, CreateConversationRequest::new);
        this.cmHandler = cmHandler;
        this.client = client;
        this.featureIsEnabled = (Boolean)ConversationalIndexConstants.ML_COMMONS_MEMORY_FEATURE_ENABLED.get(clusterService.getSettings());
        clusterService.getClusterSettings().addSettingsUpdateConsumer(ConversationalIndexConstants.ML_COMMONS_MEMORY_FEATURE_ENABLED, it -> {
            this.featureIsEnabled = it;
        });
    }

    protected void doExecute(Task task, CreateConversationRequest request, ActionListener<CreateConversationResponse> actionListener) {
        if (!this.featureIsEnabled) {
            actionListener.onFailure((Exception)new SkyliteException(ConversationalIndexConstants.ML_COMMONS_MEMORY_FEATURE_DISABLED_MESSAGE, new Object[0]));
            return;
        }
        String name = request.getName();
        String applicationType = request.getApplicationType();
        Map<String, String> additionalInfos = request.getAdditionalInfos();
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().newStoredContext(true);){
            ActionListener internalListener = ActionListenerHelper.runBefore(actionListener, () -> context.restore());
            ActionListener al = ActionListenerHelper.wrap(r -> internalListener.onResponse((Object)new CreateConversationResponse((String)r)), e -> {
                log.error("Failed to create new memory with name " + request.getName(), (Throwable)e);
                internalListener.onFailure(e);
            });
            if (name == null) {
                this.cmHandler.createConversation(al);
            } else {
                this.cmHandler.createConversation(name, applicationType, additionalInfos, al);
            }
        }
        catch (Exception e2) {
            log.error("Failed to create new memory with name " + request.getName(), (Throwable)e2);
            actionListener.onFailure(e2);
        }
    }
}

