/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.memory.conversation;

import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.common.action.ValidateActions;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.rest.RestRequest;
import java.io.IOException;

public class GetConversationRequest
extends ActionRequest {
    private String conversationId;

    public GetConversationRequest(String conversationId) {
        this.conversationId = conversationId;
    }

    public GetConversationRequest(StreamInput in) throws IOException {
        super(in);
        this.conversationId = in.readString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.conversationId);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException exception = null;
        if (this.conversationId == null) {
            exception = ValidateActions.addValidationError((String)"GetConversation Request must have a conversation id", exception);
        }
        return exception;
    }

    public static GetConversationRequest fromRestRequest(RestRequest request) throws IOException {
        String conversationId = request.param("memory_id");
        return new GetConversationRequest(conversationId);
    }

    public String getConversationId() {
        return this.conversationId;
    }
}

