/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.memory.conversation;

import io.skylite.core.action.ActionResponse;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.ml.common.conversation.Interaction;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public class GetTracesResponse
extends ActionResponse
implements ToXContentObject {
    private List<Interaction> traces;
    private int nextToken;
    private boolean hasMoreTokens;

    public GetTracesResponse(List<Interaction> traces, int nextToken, boolean hasMoreTokens) {
        this.traces = Objects.requireNonNull(traces);
        this.nextToken = nextToken;
        this.hasMoreTokens = hasMoreTokens;
    }

    public GetTracesResponse(StreamInput in) throws IOException {
        super(in);
        this.traces = in.readList(Interaction::fromStream);
        this.nextToken = in.readInt();
        this.hasMoreTokens = in.readBoolean();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeList(this.traces);
        out.writeInt(this.nextToken);
        out.writeBoolean(this.hasMoreTokens);
    }

    public boolean hasMorePages() {
        return this.hasMoreTokens;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray("traces");
        for (Interaction trace : this.traces) {
            trace.toXContent(builder, params);
        }
        builder.endArray();
        if (this.hasMoreTokens) {
            builder.field("next_token", this.nextToken);
        }
        builder.endObject();
        return builder;
    }

    public List<Interaction> getTraces() {
        return this.traces;
    }

    public int getNextToken() {
        return this.nextToken;
    }
}

