/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.memory.conversation;

import io.lucenia.ml.common.action.memory.conversation.UpdateInteractionRequest;
import io.lucenia.ml.common.conversation.ConversationalSearchService;
import io.skylite.SkyliteException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.DocWriteResponse;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.action.update.UpdateResponse;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.ml.common.conversation.ConversationalIndexConstants;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UpdateInteractionTransportAction
extends HandledTransportAction<ActionRequest, UpdateResponse> {
    private static final Logger log = LogManager.getLogger(UpdateInteractionTransportAction.class);
    Client client;
    private ConversationalSearchService cmHandler;
    private volatile boolean featureIsEnabled;

    @Inject
    public UpdateInteractionTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, ConversationalSearchService cmHandler, ClusterService clusterService) {
        super("cluster:admin/lucenia/ml/memory/interaction/update", transportService, actionFilters, UpdateInteractionRequest::new);
        this.client = client;
        this.cmHandler = cmHandler;
        this.featureIsEnabled = (Boolean)ConversationalIndexConstants.ML_COMMONS_MEMORY_FEATURE_ENABLED.get(clusterService.getSettings());
        clusterService.getClusterSettings().addSettingsUpdateConsumer(ConversationalIndexConstants.ML_COMMONS_MEMORY_FEATURE_ENABLED, it -> {
            this.featureIsEnabled = it;
        });
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<UpdateResponse> listener) {
        if (!this.featureIsEnabled) {
            listener.onFailure((Exception)new SkyliteException(ConversationalIndexConstants.ML_COMMONS_MEMORY_FEATURE_DISABLED_MESSAGE, new Object[0]));
            return;
        }
        UpdateInteractionRequest updateInteractionRequest = UpdateInteractionRequest.fromActionRequest(request);
        String interactionId = updateInteractionRequest.getInteractionId();
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().newStoredContext(true);){
            Map<String, Object> updateContent = updateInteractionRequest.getUpdateContent();
            this.cmHandler.updateInteraction(interactionId, updateContent, this.getUpdateResponseListener(interactionId, listener, context));
        }
        catch (Exception e) {
            log.error("Failed to update Message with ID " + interactionId, (Throwable)e);
            listener.onFailure(e);
        }
    }

    private ActionListener<UpdateResponse> getUpdateResponseListener(String interactionId, ActionListener<UpdateResponse> actionListener, ThreadContext.StoredContext context) {
        return ActionListenerHelper.runBefore((ActionListener)ActionListenerHelper.wrap(updateResponse -> {
            if (updateResponse != null && updateResponse.getResult() == DocWriteResponse.Result.UPDATED) {
                log.info("Successfully updated the Message with ID: {}", (Object)interactionId);
                actionListener.onResponse(updateResponse);
            } else {
                log.info("Failed to update the Message with ID: {}", (Object)interactionId);
                actionListener.onResponse(updateResponse);
            }
        }, exception -> {
            log.error("Failed to update ML Message with ID " + interactionId, (Throwable)exception);
            actionListener.onFailure(exception);
        }), () -> ((ThreadContext.StoredContext)context).restore());
    }
}

