/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.model_group;

import io.lucenia.ml.common.engine.systemindices.MLIndicesHandler;
import io.lucenia.ml.common.model.MLModelGroupManager;
import io.lucenia.ml.common.model.ModelAccessControlHelper;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.client.Client;
import io.skylite.core.client.metadata.MetadataClient;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.tasks.Task;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import io.skylite.ml.common.cluster.TenantAwareHelper;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import io.skylite.ml.common.task.MLTaskState;
import io.skylite.ml.common.transport.model_group.MLRegisterModelGroupInput;
import io.skylite.ml.common.transport.model_group.MLRegisterModelGroupRequest;
import io.skylite.ml.common.transport.model_group.MLRegisterModelGroupResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransportRegisterModelGroupAction
extends HandledTransportAction<ActionRequest, MLRegisterModelGroupResponse> {
    private static final Logger log = LogManager.getLogger(TransportRegisterModelGroupAction.class);
    private final TransportService transportService;
    private final ActionFilters actionFilters;
    private final MLIndicesHandler mlIndicesHandler;
    private final ThreadPool threadPool;
    private final Client client;
    private final MetadataClient sdkClient;
    private ClusterService clusterService;
    private ModelAccessControlHelper modelAccessControlHelper;
    private MLModelGroupManager mlModelGroupManager;
    private MLFeatureEnabledSetting mlFeatureEnabledSetting;

    @Inject
    public TransportRegisterModelGroupAction(TransportService transportService, ActionFilters actionFilters, MLIndicesHandler mlIndicesHandler, ThreadPool threadPool, Client client, MetadataClient sdkClient, ClusterService clusterService, ModelAccessControlHelper modelAccessControlHelper, MLModelGroupManager mlModelGroupManager, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/lucenia/ml/register_model_group", transportService, actionFilters, MLRegisterModelGroupRequest::new);
        this.transportService = transportService;
        this.actionFilters = actionFilters;
        this.mlIndicesHandler = mlIndicesHandler;
        this.threadPool = threadPool;
        this.client = client;
        this.sdkClient = sdkClient;
        this.clusterService = clusterService;
        this.mlModelGroupManager = mlModelGroupManager;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<MLRegisterModelGroupResponse> listener) {
        MLRegisterModelGroupRequest createModelGroupRequest = MLRegisterModelGroupRequest.fromActionRequest((ActionRequest)request);
        MLRegisterModelGroupInput createModelGroupInput = createModelGroupRequest.getRegisterModelGroupInput();
        if (!TenantAwareHelper.validateTenantId((MLFeatureEnabledSetting)this.mlFeatureEnabledSetting, (String)createModelGroupInput.getTenantId(), listener)) {
            return;
        }
        this.mlModelGroupManager.createModelGroup(createModelGroupInput, (ActionListener<String>)ActionListenerHelper.wrap(modelGroupId -> listener.onResponse((Object)new MLRegisterModelGroupResponse(modelGroupId, MLTaskState.CREATED.name())), ex -> {
            log.error("Failed to init model group index", (Throwable)ex);
            listener.onFailure(ex);
        }));
    }
}

