/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.model_group;

import io.lucenia.ml.common.model.MLModelGroupManager;
import io.lucenia.ml.common.model.ModelAccessControlHelper;
import io.lucenia.ml.common.rest.RestActionUtils;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.get.GetResponse;
import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.client.Client;
import io.skylite.core.client.metadata.GetDataObjectRequest;
import io.skylite.core.client.metadata.MetadataClient;
import io.skylite.core.client.metadata.UpdateDataObjectRequest;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.Strings;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.util.CollectionUtils;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.search.SearchHit;
import io.skylite.core.search.fetch.subphase.FetchSourceContext;
import io.skylite.core.security.auth.User;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.AccessMode;
import io.skylite.ml.common.cluster.TenantAwareHelper;
import io.skylite.ml.common.exception.MLExceptionUtils;
import io.skylite.ml.common.exception.MLValidationException;
import io.skylite.ml.common.model.MLModelGroup;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import io.skylite.ml.common.transport.model_group.MLUpdateModelGroupInput;
import io.skylite.ml.common.transport.model_group.MLUpdateModelGroupRequest;
import io.skylite.ml.common.transport.model_group.MLUpdateModelGroupResponse;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransportUpdateModelGroupAction
extends HandledTransportAction<ActionRequest, MLUpdateModelGroupResponse> {
    private static final Logger log = LogManager.getLogger(TransportUpdateModelGroupAction.class);
    private final TransportService transportService;
    private final ActionFilters actionFilters;
    private Client client;
    final MetadataClient sdkClient;
    private NamedXContentRegistry xContentRegistry;
    ClusterService clusterService;
    ModelAccessControlHelper modelAccessControlHelper;
    MLModelGroupManager mlModelGroupManager;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    @Inject
    public TransportUpdateModelGroupAction(TransportService transportService, ActionFilters actionFilters, Client client, MetadataClient sdkClient, NamedXContentRegistry xContentRegistry, ClusterService clusterService, ModelAccessControlHelper modelAccessControlHelper, MLModelGroupManager mlModelGroupManager, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/lucenia/ml/update_model_group", transportService, actionFilters, MLUpdateModelGroupRequest::new);
        this.actionFilters = actionFilters;
        this.transportService = transportService;
        this.client = client;
        this.sdkClient = sdkClient;
        this.xContentRegistry = xContentRegistry;
        this.clusterService = clusterService;
        this.modelAccessControlHelper = modelAccessControlHelper;
        this.mlModelGroupManager = mlModelGroupManager;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<MLUpdateModelGroupResponse> listener) {
        MLUpdateModelGroupRequest updateModelGroupRequest = MLUpdateModelGroupRequest.fromActionRequest((ActionRequest)request);
        MLUpdateModelGroupInput updateModelGroupInput = updateModelGroupRequest.getUpdateModelGroupInput();
        String modelGroupId = updateModelGroupInput.getModelGroupID();
        String tenantId = updateModelGroupInput.getTenantId();
        if (!TenantAwareHelper.validateTenantId((MLFeatureEnabledSetting)this.mlFeatureEnabledSetting, (String)tenantId, listener)) {
            return;
        }
        User user = RestActionUtils.getUserContext(this.client);
        FetchSourceContext fetchSourceContext = new FetchSourceContext(true, Strings.EMPTY_ARRAY, Strings.EMPTY_ARRAY);
        GetDataObjectRequest getDataObjectRequest = ((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)GetDataObjectRequest.builder().index(".plugins-ml-model-group")).id(modelGroupId)).tenantId(tenantId)).fetchSourceContext(fetchSourceContext).build();
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener wrappedListener = ActionListenerHelper.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore());
            this.sdkClient.getDataObjectAsync(getDataObjectRequest).whenComplete((r, throwable) -> {
                block18: {
                    log.debug("Completed Get Model group Request, id:{}", (Object)modelGroupId);
                    if (throwable != null) {
                        Exception cause = SkyliteExceptionsHelper.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
                        if (SkyliteExceptionsHelper.unwrap((Throwable)cause, (Class[])new Class[]{IndexNotFoundException.class}) != null) {
                            log.error("Failed to get model group index", (Throwable)cause);
                            wrappedListener.onFailure((Exception)new SkyliteStatusException("Failed to find model group", RestStatus.NOT_FOUND, new Object[0]));
                        } else {
                            log.error("Failed to get ML group {}", (Object)modelGroupId);
                            wrappedListener.onFailure(cause);
                        }
                    } else {
                        try {
                            GetResponse gr = r.getResponse();
                            if (gr != null && gr.isExists()) {
                                try (XContentParser parser = MediaTypeRegistry.JSON.xContent().createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, gr.getSourceAsString());){
                                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                                    MLModelGroup mlModelGroup = MLModelGroup.parse((XContentParser)parser);
                                    if (TenantAwareHelper.validateTenantResource((MLFeatureEnabledSetting)this.mlFeatureEnabledSetting, (String)tenantId, (String)mlModelGroup.getTenantId(), (ActionListener)wrappedListener)) {
                                        if (this.modelAccessControlHelper.isSecurityEnabledAndModelAccessControlEnabled(user)) {
                                            this.validateRequestForAccessControl(updateModelGroupInput, user, mlModelGroup);
                                        } else {
                                            this.validateSecurityDisabledOrModelAccessControlDisabled(updateModelGroupInput);
                                        }
                                        this.updateModelGroup(modelGroupId, r.source(), updateModelGroupInput, (ActionListener<MLUpdateModelGroupResponse>)wrappedListener, user);
                                    }
                                    break block18;
                                }
                                catch (Exception e) {
                                    log.error("Failed to parse ml connector {}", (Object)r.id());
                                    wrappedListener.onFailure(e);
                                }
                                break block18;
                            }
                            wrappedListener.onFailure((Exception)new SkyliteStatusException("Failed to find model group with the provided model group id: " + modelGroupId, RestStatus.NOT_FOUND, new Object[0]));
                        }
                        catch (Exception e) {
                            wrappedListener.onFailure(e);
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            MLExceptionUtils.logException((String)"Failed to Update model group", (Exception)e, (Logger)log);
            listener.onFailure(e);
        }
    }

    private void updateModelGroup(String modelGroupId, Map<String, Object> source, MLUpdateModelGroupInput updateModelGroupInput, ActionListener<MLUpdateModelGroupResponse> listener, User user) {
        String modelGroupName = (String)source.get("name");
        if (updateModelGroupInput.getModelAccessMode() != null) {
            source.put("access", updateModelGroupInput.getModelAccessMode().getValue());
            if (AccessMode.RESTRICTED != updateModelGroupInput.getModelAccessMode()) {
                source.put("backend_roles", List.of());
            }
        } else if (updateModelGroupInput.getBackendRoles() != null || Boolean.TRUE.equals(updateModelGroupInput.getIsAddAllBackendRoles())) {
            source.put("access", AccessMode.RESTRICTED.getValue());
        }
        if (updateModelGroupInput.getBackendRoles() != null) {
            source.put("backend_roles", updateModelGroupInput.getBackendRoles());
        }
        if (Boolean.TRUE.equals(updateModelGroupInput.getIsAddAllBackendRoles())) {
            source.put("backend_roles", user.getBackendRoles());
        }
        if (Strings.hasText((String)updateModelGroupInput.getDescription())) {
            source.put("description", updateModelGroupInput.getDescription());
        }
        if (Strings.hasText((String)updateModelGroupInput.getName()) && !updateModelGroupInput.getName().equals(modelGroupName)) {
            this.mlModelGroupManager.validateUniqueModelGroupName(updateModelGroupInput.getName(), updateModelGroupInput.getTenantId(), (ActionListener<SearchResponse>)ActionListenerHelper.wrap(modelGroups -> {
                if (modelGroups != null && modelGroups.getHits().getTotalHits() != null && modelGroups.getHits().getTotalHits().value() != 0L) {
                    for (SearchHit documentFields : modelGroups.getHits()) {
                        String id = documentFields.getId();
                        listener.onFailure((Exception)new IllegalArgumentException("The name you provided is already being used by another model with ID: " + id + ". Please provide a different name"));
                    }
                } else {
                    source.put("name", updateModelGroupInput.getName());
                    this.updateModelGroup(modelGroupId, updateModelGroupInput.getTenantId(), source, listener);
                }
            }, e -> {
                log.error("Failed to search model group index", (Throwable)e);
                listener.onFailure(e);
            }));
        } else {
            this.updateModelGroup(modelGroupId, updateModelGroupInput.getTenantId(), source, listener);
        }
    }

    private void updateModelGroup(String modelGroupId, String tenantId, Map<String, Object> source, ActionListener<MLUpdateModelGroupResponse> listener) {
        UpdateDataObjectRequest updateDataObjectRequest = ((UpdateDataObjectRequest.Builder)((UpdateDataObjectRequest.Builder)((UpdateDataObjectRequest.Builder)UpdateDataObjectRequest.builder().index(".plugins-ml-model-group")).id(modelGroupId)).tenantId(tenantId)).dataObject(source).build();
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener wrappedListener = ActionListenerHelper.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore());
            this.sdkClient.updateDataObjectAsync(updateDataObjectRequest).whenComplete((ur, ut) -> {
                if (ut == null) {
                    wrappedListener.onResponse((Object)new MLUpdateModelGroupResponse("Updated"));
                } else {
                    Exception e = SkyliteExceptionsHelper.unwrapAndConvertToException((Throwable)ut, (Class[])new Class[0]);
                    log.error("Failed to update model group {}", (Object)modelGroupId);
                    wrappedListener.onFailure((Exception)new MLValidationException("Failed to update Model Group"));
                }
            });
        }
        catch (Exception e) {
            MLExceptionUtils.logException((String)"Failed to Update model group ", (Exception)e, (Logger)log);
            listener.onFailure(e);
        }
    }

    private void validateRequestForAccessControl(MLUpdateModelGroupInput input, User user, MLModelGroup mlModelGroup) {
        if (this.hasAccessControlChange(input) && !this.modelAccessControlHelper.isOwner(mlModelGroup.getOwner(), user) && !this.modelAccessControlHelper.isAdmin(user)) {
            throw new IllegalArgumentException("Only owner or admin can update access control data.");
        }
        if (!(this.modelAccessControlHelper.isAdmin(user) || this.modelAccessControlHelper.isOwner(mlModelGroup.getOwner(), user) || this.modelAccessControlHelper.isUserHasBackendRole(user, mlModelGroup))) {
            throw new IllegalArgumentException("You don't have permission to update this model group.");
        }
        if (this.modelAccessControlHelper.isOwner(mlModelGroup.getOwner(), user) && !this.modelAccessControlHelper.isAdmin(user) && !this.modelAccessControlHelper.isOwnerStillHasPermission(user, mlModelGroup)) {
            throw new IllegalArgumentException("You don't have the specified backend role to update this model group. For more information, contact your administrator.");
        }
        AccessMode accessMode = input.getModelAccessMode();
        if (!(AccessMode.PUBLIC != accessMode && AccessMode.PRIVATE != accessMode || CollectionUtils.isEmpty((Collection)input.getBackendRoles()) && !Boolean.TRUE.equals(input.getIsAddAllBackendRoles()))) {
            throw new IllegalArgumentException("You can specify backend roles only for a model group with the restricted access mode.");
        }
        if (accessMode == null || AccessMode.RESTRICTED == accessMode) {
            if (this.modelAccessControlHelper.isAdmin(user) && Boolean.TRUE.equals(input.getIsAddAllBackendRoles())) {
                throw new IllegalArgumentException("Admin users cannot add all backend roles to a model group.");
            }
            if (Boolean.TRUE.equals(input.getIsAddAllBackendRoles()) && CollectionUtils.isEmpty((Collection)user.getBackendRoles())) {
                throw new IllegalArgumentException("You don't have any backend roles.");
            }
            if (CollectionUtils.isEmpty((Collection)input.getBackendRoles()) && Boolean.FALSE.equals(input.getIsAddAllBackendRoles())) {
                throw new IllegalArgumentException("You have to specify backend roles when add all backend roles is set to false.");
            }
            if (!CollectionUtils.isEmpty((Collection)input.getBackendRoles()) && Boolean.TRUE.equals(input.getIsAddAllBackendRoles())) {
                throw new IllegalArgumentException("You cannot specify backend roles and add all backend roles at the same time.");
            }
            if (AccessMode.RESTRICTED == accessMode && CollectionUtils.isEmpty((Collection)input.getBackendRoles()) && !Boolean.TRUE.equals(input.getIsAddAllBackendRoles())) {
                throw new IllegalArgumentException("You must specify one or more backend roles or add all backend roles to register a restricted model group.");
            }
            if (!(this.modelAccessControlHelper.isAdmin(user) || CollectionUtils.isEmpty((Collection)input.getBackendRoles()) || new HashSet(user.getBackendRoles()).containsAll(input.getBackendRoles()))) {
                throw new IllegalArgumentException("You don't have the backend roles specified.");
            }
        }
    }

    private boolean hasAccessControlChange(MLUpdateModelGroupInput input) {
        return input.getModelAccessMode() != null || input.getIsAddAllBackendRoles() != null || input.getBackendRoles() != null;
    }

    private void validateSecurityDisabledOrModelAccessControlDisabled(MLUpdateModelGroupInput input) {
        if (input.getModelAccessMode() != null || input.getIsAddAllBackendRoles() != null || !CollectionUtils.isEmpty((Collection)input.getBackendRoles())) {
            throw new IllegalArgumentException("You cannot specify model access control parameters because the Security plugin or model access control is disabled on your cluster.");
        }
    }
}

