/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.models;

import io.lucenia.ml.common.model.ModelAccessControlHelper;
import io.lucenia.ml.common.rest.RestActionUtils;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.get.GetResponse;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.client.Client;
import io.skylite.core.client.metadata.GetDataObjectRequest;
import io.skylite.core.client.metadata.MetadataClient;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.search.fetch.subphase.FetchSourceContext;
import io.skylite.core.security.auth.User;
import io.skylite.core.settings.Settings;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.cluster.TenantAwareHelper;
import io.skylite.ml.common.connector.Connector;
import io.skylite.ml.common.model.MLModel;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import io.skylite.ml.common.transport.model.MLModelGetRequest;
import io.skylite.ml.common.transport.model.MLModelGetResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GetModelTransportAction
extends HandledTransportAction<ActionRequest, MLModelGetResponse> {
    private static final Logger log = LogManager.getLogger(GetModelTransportAction.class);
    private final Client client;
    private final MetadataClient sdkClient;
    private final NamedXContentRegistry xContentRegistry;
    private final ClusterService clusterService;
    private final ModelAccessControlHelper modelAccessControlHelper;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;
    private Settings settings;

    @Inject
    public GetModelTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, MetadataClient sdkClient, Settings settings, NamedXContentRegistry xContentRegistry, ClusterService clusterService, ModelAccessControlHelper modelAccessControlHelper, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/lucenia/ml/models/get", transportService, actionFilters, MLModelGetRequest::new);
        this.client = client;
        this.sdkClient = sdkClient;
        this.settings = settings;
        this.xContentRegistry = xContentRegistry;
        this.clusterService = clusterService;
        this.modelAccessControlHelper = modelAccessControlHelper;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<MLModelGetResponse> actionListener) {
        MLModelGetRequest mlModelGetRequest = MLModelGetRequest.fromActionRequest((ActionRequest)request);
        String modelId = mlModelGetRequest.getModelId();
        String tenantId = mlModelGetRequest.getTenantId();
        if (!TenantAwareHelper.validateTenantId((MLFeatureEnabledSetting)this.mlFeatureEnabledSetting, (String)tenantId, actionListener)) {
            return;
        }
        FetchSourceContext fetchSourceContext = RestActionUtils.getFetchSourceContext(mlModelGetRequest.isReturnContent());
        GetDataObjectRequest getDataObjectRequest = ((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)GetDataObjectRequest.builder().index(".plugins-ml-model")).id(modelId)).tenantId(tenantId)).fetchSourceContext(fetchSourceContext).build();
        User user = RestActionUtils.getUserContext(this.client);
        boolean isSuperAdmin = this.isSuperAdminUserWrapper(this.clusterService, this.client);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener wrappedListener = ActionListenerHelper.runBefore(actionListener, () -> ((ThreadContext.StoredContext)context).restore());
            this.sdkClient.getDataObjectAsync(getDataObjectRequest).whenComplete((r, throwable) -> {
                block21: {
                    if (throwable == null) {
                        try {
                            GetResponse gr = r.getResponse();
                            if (gr != null && gr.isExists()) {
                                try (XContentParser parser = MediaTypeRegistry.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, gr.getSourceAsString());){
                                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                                    String algorithmName = r.source().get("algorithm").toString();
                                    Boolean isHidden = (Boolean)r.source().get("is_hidden");
                                    MLModel mlModel = MLModel.parse((XContentParser)parser, (String)algorithmName);
                                    if (!TenantAwareHelper.validateTenantResource((MLFeatureEnabledSetting)this.mlFeatureEnabledSetting, (String)tenantId, (String)mlModel.getTenantId(), (ActionListener)actionListener)) {
                                        return;
                                    }
                                    if (isHidden != null && isHidden.booleanValue()) {
                                        if (isSuperAdmin || !mlModelGetRequest.isUserInitiatedGetRequest()) {
                                            wrappedListener.onResponse((Object)MLModelGetResponse.builder().mlModel(mlModel).build());
                                        } else {
                                            wrappedListener.onFailure((Exception)new SkyliteStatusException("User doesn't have privilege to perform this operation on this model", RestStatus.FORBIDDEN, new Object[0]));
                                        }
                                    } else {
                                        this.modelAccessControlHelper.validateModelGroupAccess(user, mlModel.getModelGroupId(), this.client, (ActionListener<Boolean>)ActionListenerHelper.wrap(access -> {
                                            if (!access.booleanValue()) {
                                                wrappedListener.onFailure((Exception)new SkyliteStatusException("User doesn't have privilege to perform this operation on this model", RestStatus.FORBIDDEN, new Object[0]));
                                            } else {
                                                log.debug("Completed Get Model Request, id:{}", (Object)modelId);
                                                Connector connector = mlModel.getConnector();
                                                if (connector != null) {
                                                    connector.removeCredential();
                                                }
                                                wrappedListener.onResponse((Object)MLModelGetResponse.builder().mlModel(mlModel).build());
                                            }
                                        }, e -> {
                                            log.error("Failed to validate Access for Model Id {}", (Object)modelId);
                                            wrappedListener.onFailure(e);
                                        }));
                                    }
                                    break block21;
                                }
                                catch (Exception e2) {
                                    log.error("Failed to parse ml model {}", (Object)r.id());
                                    wrappedListener.onFailure(e2);
                                }
                                break block21;
                            }
                            wrappedListener.onFailure((Exception)new SkyliteStatusException("Failed to find model with the provided model id: " + modelId, RestStatus.NOT_FOUND, new Object[0]));
                        }
                        catch (Exception e3) {
                            wrappedListener.onFailure(e3);
                        }
                    } else {
                        Exception e4 = SkyliteExceptionsHelper.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
                        if (SkyliteExceptionsHelper.unwrap((Throwable)e4, (Class[])new Class[]{IndexNotFoundException.class}) != null) {
                            wrappedListener.onFailure((Exception)new SkyliteStatusException("Fail to find model", RestStatus.NOT_FOUND, new Object[0]));
                        } else {
                            log.error("Failed to get ML model {}", (Object)modelId);
                            wrappedListener.onFailure(e4);
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            log.error("Failed to get ML model {}", (Object)modelId);
            actionListener.onFailure(e);
        }
    }

    boolean isSuperAdminUserWrapper(ClusterService clusterService, Client client) {
        return RestActionUtils.isSuperAdminUser(clusterService, client);
    }
}

