/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.models;

import io.lucenia.ml.common.action.handler.MLSearchHandler;
import io.lucenia.ml.common.transport.search.MLSearchActionRequest;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.client.metadata.MetadataClient;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.ml.common.cluster.TenantAwareHelper;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SearchModelTransportAction
extends HandledTransportAction<MLSearchActionRequest, SearchResponse> {
    private static final Logger log = LogManager.getLogger(SearchModelTransportAction.class);
    private final MLSearchHandler mlSearchHandler;
    private final MetadataClient sdkClient;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    @Inject
    public SearchModelTransportAction(TransportService transportService, ActionFilters actionFilters, MetadataClient sdkClient, MLSearchHandler mlSearchHandler, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/lucenia/ml/models/search", transportService, actionFilters, MLSearchActionRequest::new);
        this.sdkClient = sdkClient;
        this.mlSearchHandler = mlSearchHandler;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    protected void doExecute(Task task, MLSearchActionRequest request, ActionListener<SearchResponse> actionListener) {
        String tenantId = request.getTenantId();
        if (!TenantAwareHelper.validateTenantId((MLFeatureEnabledSetting)this.mlFeatureEnabledSetting, (String)tenantId, actionListener)) {
            return;
        }
        this.mlSearchHandler.search(this.sdkClient, request, tenantId, actionListener);
    }
}

