/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.profile;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.ml.common.profile.MLModelProfile;
import io.skylite.ml.common.task.MLTask;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class MLProfileModelResponse
implements ToXContentFragment,
Writeable {
    private String[] targetWorkerNodes;
    private String[] workerNodes;
    private Map<String, MLModelProfile> mlModelProfileMap = new HashMap<String, MLModelProfile>();
    private Map<String, MLTask> mlTaskMap = new HashMap<String, MLTask>();

    public MLProfileModelResponse() {
    }

    public MLProfileModelResponse(String[] targetWorkerNodes, String[] workerNodes) {
        this.targetWorkerNodes = targetWorkerNodes;
        this.workerNodes = workerNodes;
    }

    public MLProfileModelResponse(StreamInput in) throws IOException {
        this.workerNodes = in.readOptionalStringArray();
        this.targetWorkerNodes = in.readOptionalStringArray();
        if (in.readBoolean()) {
            this.mlModelProfileMap = in.readMap(StreamInput::readString, MLModelProfile::new);
        }
        if (in.readBoolean()) {
            this.mlTaskMap = in.readMap(StreamInput::readString, MLTask::new);
        }
    }

    public void setTargetWorkerNodes(String[] targetWorkerNodes) {
        this.targetWorkerNodes = targetWorkerNodes;
    }

    public void setWorkerNodes(String[] workerNodes) {
        this.workerNodes = workerNodes;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.targetWorkerNodes != null) {
            builder.field("target_worker_nodes", (Object)this.targetWorkerNodes);
        }
        if (this.workerNodes != null) {
            builder.field("worker_nodes", (Object)this.workerNodes);
        }
        if (this.mlModelProfileMap.size() > 0) {
            builder.startObject("nodes");
            for (Map.Entry<String, MLModelProfile> entry : this.mlModelProfileMap.entrySet()) {
                builder.field(entry.getKey(), (ToXContent)entry.getValue());
            }
            builder.endObject();
        }
        if (this.mlTaskMap.size() > 0) {
            builder.startObject("tasks");
            for (Map.Entry<String, MLModelProfile> entry : this.mlTaskMap.entrySet()) {
                builder.field(entry.getKey(), (ToXContent)entry.getValue());
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput streamOutput) throws IOException {
        streamOutput.writeOptionalStringArray(this.workerNodes);
        streamOutput.writeOptionalStringArray(this.targetWorkerNodes);
        if (this.mlModelProfileMap.size() > 0) {
            streamOutput.writeBoolean(true);
            streamOutput.writeMap(this.mlModelProfileMap, StreamOutput::writeString, (o, r) -> r.writeTo(o));
        } else {
            streamOutput.writeBoolean(false);
        }
        if (this.mlTaskMap.size() > 0) {
            streamOutput.writeBoolean(true);
            streamOutput.writeMap(this.mlTaskMap, StreamOutput::writeString, (o, r) -> r.writeTo(o));
        } else {
            streamOutput.writeBoolean(false);
        }
    }

    public String[] getTargetWorkerNodes() {
        return this.targetWorkerNodes;
    }

    public String[] getWorkerNodes() {
        return this.workerNodes;
    }

    public Map<String, MLModelProfile> getMlModelProfileMap() {
        return this.mlModelProfileMap;
    }

    public Map<String, MLTask> getMlTaskMap() {
        return this.mlTaskMap;
    }
}

