/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.profile;

import io.skylite.core.action.support.nodes.BaseNodeResponse;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.ml.common.profile.MLModelProfile;
import io.skylite.ml.common.task.MLTask;
import java.io.IOException;
import java.util.Map;

public class MLProfileNodeResponse
extends BaseNodeResponse
implements ToXContentFragment {
    private Map<String, MLTask> mlNodeTasks;
    private Map<String, MLModelProfile> mlNodeModels;

    public MLProfileNodeResponse(StreamInput in) throws IOException {
        super(in);
        if (in.readBoolean()) {
            this.mlNodeTasks = in.readMap(StreamInput::readString, MLTask::new);
        }
        if (in.readBoolean()) {
            this.mlNodeModels = in.readMap(StreamInput::readString, MLModelProfile::new);
        }
    }

    public MLProfileNodeResponse(DiscoveryNode node, Map<String, MLTask> nodeTasks, Map<String, MLModelProfile> mlNodeModels) {
        super(node);
        this.mlNodeTasks = nodeTasks;
        this.mlNodeModels = mlNodeModels;
    }

    public static MLProfileNodeResponse readProfile(StreamInput in) throws IOException {
        return new MLProfileNodeResponse(in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (this.mlNodeTasks != null) {
            out.writeBoolean(true);
            out.writeMap(this.mlNodeTasks, StreamOutput::writeString, (o, r) -> r.writeTo(o));
        } else {
            out.writeBoolean(false);
        }
        if (this.mlNodeModels != null) {
            out.writeBoolean(true);
            out.writeMap(this.mlNodeModels, StreamOutput::writeString, (o, r) -> r.writeTo(o));
        } else {
            out.writeBoolean(false);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.mlNodeTasks != null && this.mlNodeTasks.size() > 0) {
            builder.startObject("tasks");
            for (Map.Entry<String, MLTask> entry : this.mlNodeTasks.entrySet()) {
                builder.field(entry.getKey(), (ToXContent)entry.getValue());
            }
            builder.endObject();
        }
        if (this.mlNodeModels != null && this.mlNodeModels.size() > 0) {
            builder.startObject("models");
            for (Map.Entry<String, MLTask> entry : this.mlNodeModels.entrySet()) {
                builder.field(entry.getKey(), (ToXContent)entry.getValue());
            }
            builder.endObject();
        }
        return builder;
    }

    public boolean isEmpty() {
        return !(this.mlNodeTasks != null && this.mlNodeTasks.size() != 0 || this.mlNodeModels != null && this.mlNodeModels.size() != 0);
    }

    public int getNodeTasksSize() {
        return this.mlNodeTasks == null ? 0 : this.mlNodeTasks.size();
    }

    public int getNodeModelsSize() {
        return this.mlNodeModels == null ? 0 : this.mlNodeModels.size();
    }

    public Map<String, MLTask> getMlNodeTasks() {
        return this.mlNodeTasks;
    }

    public Map<String, MLModelProfile> getMlNodeModels() {
        return this.mlNodeModels;
    }
}

