/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.profile;

import io.skylite.Version;
import io.skylite.core.action.support.nodes.BaseNodesRequest;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.ml.common.profile.MLProfileInput;
import io.skylite.ml.common.transport.register.MLRegisterModelInput;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;

public class MLProfileRequest
extends BaseNodesRequest<MLProfileRequest> {
    private MLProfileInput mlProfileInput;
    private Set<String> hiddenModelIds = Collections.emptySet();

    public MLProfileRequest(StreamInput input) throws IOException {
        super(input);
        Version streamInputVersion = input.getVersion();
        this.mlProfileInput = new MLProfileInput(input);
        if (streamInputVersion.onOrAfter((Version)MLRegisterModelInput.MINIMAL_SUPPORTED_VERSION_FOR_AGENT_FRAMEWORK)) {
            this.hiddenModelIds = input.readSet(StreamInput::readString);
        }
    }

    public MLProfileRequest(String[] nodeIds, MLProfileInput mlProfileInput) {
        super(nodeIds);
        this.mlProfileInput = mlProfileInput;
    }

    public void writeTo(StreamOutput output) throws IOException {
        Version streamOutputVersion = output.getVersion();
        super.writeTo(output);
        this.mlProfileInput.writeTo(output);
        if (streamOutputVersion.onOrAfter((Version)MLRegisterModelInput.MINIMAL_SUPPORTED_VERSION_FOR_AGENT_FRAMEWORK)) {
            output.writeCollection(this.hiddenModelIds, StreamOutput::writeString);
        }
    }

    public MLProfileInput getMlProfileInput() {
        return this.mlProfileInput;
    }

    public Set<String> getHiddenModelIds() {
        return this.hiddenModelIds;
    }

    public void setHiddenModelIds(Set<String> hiddenModelIds) {
        this.hiddenModelIds = hiddenModelIds;
    }
}

