/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.stats;

import io.skylite.Version;
import io.skylite.core.action.support.nodes.BaseNodesRequest;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.ml.common.stats.MLNodeLevelStat;
import io.skylite.ml.common.stats.MLStatLevel;
import io.skylite.ml.common.stats.MLStatsInput;
import io.skylite.ml.common.transport.register.MLRegisterModelInput;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;

public class MLStatsNodesRequest
extends BaseNodesRequest<MLStatsNodesRequest> {
    private MLStatsInput mlStatsInput;
    private Set<String> hiddenModelIds = Collections.emptySet();

    public MLStatsNodesRequest(StreamInput in) throws IOException {
        super(in);
        Version streamInputVersion = in.getVersion();
        this.mlStatsInput = new MLStatsInput(in);
        if (streamInputVersion.onOrAfter((Version)MLRegisterModelInput.MINIMAL_SUPPORTED_VERSION_FOR_AGENT_FRAMEWORK)) {
            this.hiddenModelIds = in.readSet(StreamInput::readString);
        }
    }

    public MLStatsNodesRequest(String[] nodeIds, MLStatsInput mlStatsInput) {
        super(nodeIds);
        this.mlStatsInput = mlStatsInput;
    }

    public MLStatsNodesRequest(DiscoveryNode ... nodes) {
        super(nodes);
        this.mlStatsInput = new MLStatsInput();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        Version streamOutputVersion = out.getVersion();
        this.mlStatsInput.writeTo(out);
        if (streamOutputVersion.onOrAfter((Version)MLRegisterModelInput.MINIMAL_SUPPORTED_VERSION_FOR_AGENT_FRAMEWORK)) {
            out.writeCollection(this.hiddenModelIds, StreamOutput::writeString);
        }
    }

    public void addNodeLevelStats(Set<MLNodeLevelStat> stats) {
        this.mlStatsInput.getTargetStatLevels().add(MLStatLevel.NODE);
        this.mlStatsInput.getNodeLevelStats().addAll(stats);
    }

    public MLStatsInput getMlStatsInput() {
        return this.mlStatsInput;
    }

    public Set<String> getHiddenModelIds() {
        return this.hiddenModelIds;
    }

    public void setHiddenModelIds(Set<String> hiddenModelIds) {
        this.hiddenModelIds = hiddenModelIds;
    }
}

