/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.tasks;

import io.lucenia.ml.common.engine.encryptors.AWSEncryptorImpl;
import io.lucenia.ml.common.helpers.ConnectorAccessControlHelper;
import io.lucenia.ml.common.model.MLModelManager;
import io.lucenia.ml.common.model.ModelAccessControlHelper;
import io.lucenia.ml.common.rest.RestActionUtils;
import io.lucenia.ml.common.task.MLTaskManager;
import io.skylite.ResourceNotFoundException;
import io.skylite.SkyliteException;
import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.get.GetRequest;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.client.Client;
import io.skylite.core.client.ReleasableSkyliteClient;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.script.ScriptService;
import io.skylite.core.security.auth.User;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.FunctionName;
import io.skylite.ml.common.cluster.MLNodeUtils;
import io.skylite.ml.common.connector.Connector;
import io.skylite.ml.common.connector.ConnectorAction;
import io.skylite.ml.common.dataset.MLInputDataset;
import io.skylite.ml.common.dataset.remote.RemoteInferenceInputDataSet;
import io.skylite.ml.common.engine.MLEngineClassLoader;
import io.skylite.ml.common.exception.MLResourceNotFoundException;
import io.skylite.ml.common.exception.MLValidationException;
import io.skylite.ml.common.input.MLInput;
import io.skylite.ml.common.model.MLModel;
import io.skylite.ml.common.output.model.ModelTensorOutput;
import io.skylite.ml.common.output.model.ModelTensors;
import io.skylite.ml.common.remote.ConnectorUtils;
import io.skylite.ml.common.remote.RemoteConnectorExecutor;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import io.skylite.ml.common.task.MLTask;
import io.skylite.ml.common.task.MLTaskType;
import io.skylite.ml.common.transport.MLTaskResponse;
import io.skylite.ml.common.transport.task.MLCancelBatchJobRequest;
import io.skylite.ml.common.transport.task.MLCancelBatchJobResponse;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CancelBatchJobTransportAction
extends HandledTransportAction<ActionRequest, MLCancelBatchJobResponse> {
    private static final Logger log = LogManager.getLogger(CancelBatchJobTransportAction.class);
    Client client;
    NamedXContentRegistry xContentRegistry;
    ClusterService clusterService;
    ScriptService scriptService;
    ConnectorAccessControlHelper connectorAccessControlHelper;
    ModelAccessControlHelper modelAccessControlHelper;
    AWSEncryptorImpl encryptor;
    MLModelManager mlModelManager;
    MLTaskManager mlTaskManager;
    private MLFeatureEnabledSetting mlFeatureEnabledSetting;

    @Inject
    public CancelBatchJobTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, NamedXContentRegistry xContentRegistry, ClusterService clusterService, ScriptService scriptService, ConnectorAccessControlHelper connectorAccessControlHelper, ModelAccessControlHelper modelAccessControlHelper, AWSEncryptorImpl encryptor, MLTaskManager mlTaskManager, MLModelManager mlModelManager, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/lucenia/ml/tasks/cancel", transportService, actionFilters, MLCancelBatchJobRequest::new);
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.clusterService = clusterService;
        this.scriptService = scriptService;
        this.connectorAccessControlHelper = connectorAccessControlHelper;
        this.modelAccessControlHelper = modelAccessControlHelper;
        this.encryptor = encryptor;
        this.mlTaskManager = mlTaskManager;
        this.mlModelManager = mlModelManager;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<MLCancelBatchJobResponse> actionListener) {
        MLCancelBatchJobRequest mlCancelBatchJobRequest = MLCancelBatchJobRequest.fromActionRequest((ActionRequest)request);
        String taskId = mlCancelBatchJobRequest.getTaskId();
        GetRequest getRequest = new GetRequest(".plugins-ml-task").id(taskId);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.client.get(getRequest, ActionListenerHelper.runBefore((ActionListener)ActionListenerHelper.wrap(r -> {
                log.debug("Completed Get Task Request, id:{}", (Object)taskId);
                if (r != null && r.isExists()) {
                    try (XContentParser parser = MLNodeUtils.createXContentParserFromRegistry((NamedXContentRegistry)this.xContentRegistry, (BytesReference)r.getSourceAsBytesRef());){
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                        MLTask mlTask = MLTask.parse((XContentParser)parser);
                        if (mlTask.getTaskType() == MLTaskType.BATCH_PREDICTION && !this.mlFeatureEnabledSetting.isOfflineBatchInferenceEnabled().booleanValue()) {
                            throw new IllegalStateException("Offline Batch Inference is currently disabled. To enable it, update the setting \"plugins.ml_commons.offline_batch_inference_enabled\" to true.");
                        }
                        if (mlTask.getTaskType() == MLTaskType.BATCH_PREDICTION && mlTask.getFunctionName() == FunctionName.REMOTE) {
                            this.processRemoteBatchPrediction(mlTask, actionListener);
                        } else {
                            actionListener.onFailure((Exception)new IllegalArgumentException("The task ID you provided does not have any associated batch job"));
                        }
                    }
                    catch (Exception e) {
                        log.error("Failed to parse ml task {}", (Object)r.getId());
                        actionListener.onFailure(e);
                    }
                } else {
                    actionListener.onFailure((Exception)new SkyliteStatusException("Fail to find task", RestStatus.NOT_FOUND, new Object[0]));
                }
            }, e -> {
                if (e instanceof IndexNotFoundException) {
                    actionListener.onFailure((Exception)new MLResourceNotFoundException("Fail to find task"));
                } else {
                    log.error("Failed to get ML task {}", (Object)taskId);
                    actionListener.onFailure(e);
                }
            }), () -> ((ThreadContext.StoredContext)context).restore()));
        }
        catch (Exception e2) {
            log.error("Failed to get ML task {}", (Object)taskId);
            actionListener.onFailure(e2);
        }
    }

    private void processRemoteBatchPrediction(MLTask mlTask, ActionListener<MLCancelBatchJobResponse> actionListener) {
        Map remoteJob = mlTask.getRemoteJob();
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (Map.Entry entry : remoteJob.entrySet()) {
            if (entry.getValue() instanceof String) {
                parameters.put((String)entry.getKey(), (String)entry.getValue());
                continue;
            }
            log.debug("Value for key {} is not a String", entry.getKey());
        }
        parameters.computeIfAbsent("TransformJobName", key -> Optional.ofNullable((String)parameters.get("TransformJobArn")).map(jobArn -> jobArn.substring(jobArn.lastIndexOf("/") + 1)).orElse(null));
        RemoteInferenceInputDataSet inferenceInputDataSet = new RemoteInferenceInputDataSet(parameters, ConnectorAction.ActionType.BATCH_PREDICT_STATUS, null);
        MLInput mlInput = MLInput.builder().algorithm(FunctionName.REMOTE).inputDataset((MLInputDataset)inferenceInputDataSet).build();
        String modelId = mlTask.getModelId();
        User user = RestActionUtils.getUserContext(this.client);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener getModelListener = ActionListenerHelper.wrap(model -> this.modelAccessControlHelper.validateModelGroupAccess(user, model.getModelGroupId(), this.client, (ActionListener<Boolean>)ActionListenerHelper.wrap(access -> {
                if (!access.booleanValue()) {
                    actionListener.onFailure((Exception)new MLValidationException("You don't have permission to cancel this batch job"));
                } else if (model.getConnector() != null) {
                    Connector connector2 = model.getConnector();
                    this.executeConnector(connector2, mlInput, actionListener);
                } else if (this.clusterService.state().metadata().hasIndex(".plugins-ml-connector")) {
                    ActionListener listener = ActionListenerHelper.wrap(connector -> this.executeConnector((Connector)connector, mlInput, actionListener), e -> {
                        log.error("Failed to get connector {}", (Object)model.getConnectorId());
                        actionListener.onFailure(e);
                    });
                    try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
                        this.connectorAccessControlHelper.getConnector(this.client, model.getConnectorId(), (ActionListener<Connector>)ActionListenerHelper.runBefore((ActionListener)listener, () -> ((ThreadContext.StoredContext)threadContext).restore()));
                    }
                } else {
                    actionListener.onFailure((Exception)new ResourceNotFoundException("Can't find connector " + model.getConnectorId(), new Object[0]));
                }
            }, e -> {
                log.error("Failed to validate Access for Model Group " + model.getModelGroupId(), (Throwable)e);
                actionListener.onFailure(e);
            })), e -> {
                log.error("Failed to retrieve the ML model with the given ID", (Throwable)e);
                actionListener.onFailure((Exception)new SkyliteStatusException("Failed to retrieve the ML model for the given task ID", RestStatus.NOT_FOUND, new Object[0]));
            });
            this.mlModelManager.getModel(modelId, null, null, (ActionListener<MLModel>)ActionListenerHelper.runBefore((ActionListener)getModelListener, () -> ((ThreadContext.StoredContext)context).restore()));
        }
        catch (Exception e2) {
            log.error("Unable to fetch cancel batch job in ml task ", (Throwable)e2);
            throw new SkyliteException("Unable to fetch cancel batch job in ml task " + e2.getMessage(), new Object[0]);
        }
    }

    private void executeConnector(Connector connector, MLInput mlInput, ActionListener<MLCancelBatchJobResponse> actionListener) {
        Optional cancelBatchPredictAction = connector.findAction(ConnectorAction.ActionType.CANCEL_BATCH_PREDICT.name());
        if (cancelBatchPredictAction.isEmpty() || ((ConnectorAction)cancelBatchPredictAction.get()).getRequestBody() == null) {
            ConnectorAction connectorAction = ConnectorUtils.createConnectorAction((Connector)connector, (ConnectorAction.ActionType)ConnectorAction.ActionType.CANCEL_BATCH_PREDICT);
            connector.addAction(connectorAction);
        }
        connector.decrypt(ConnectorAction.ActionType.CANCEL_BATCH_PREDICT.name(), (credential, tenantId) -> this.encryptor.decrypt((String)credential, null), null);
        RemoteConnectorExecutor connectorExecutor = (RemoteConnectorExecutor)MLEngineClassLoader.initInstance((Object)connector.getProtocol(), (Object)connector, Connector.class);
        connectorExecutor.setScriptService(this.scriptService);
        connectorExecutor.setClusterService(this.clusterService);
        connectorExecutor.setClient((ReleasableSkyliteClient)this.client);
        connectorExecutor.setXContentRegistry(this.xContentRegistry);
        connectorExecutor.executeAction(ConnectorAction.ActionType.CANCEL_BATCH_PREDICT.name(), mlInput, ActionListenerHelper.wrap(taskResponse -> this.processTaskResponse((MLTaskResponse)taskResponse, actionListener), arg_0 -> actionListener.onFailure(arg_0)));
    }

    private void processTaskResponse(MLTaskResponse taskResponse, ActionListener<MLCancelBatchJobResponse> actionListener) {
        try {
            ModelTensorOutput tensorOutput = (ModelTensorOutput)taskResponse.getOutput();
            if (tensorOutput != null && tensorOutput.getMlModelOutputs() != null && !tensorOutput.getMlModelOutputs().isEmpty()) {
                ModelTensors modelOutput = (ModelTensors)tensorOutput.getMlModelOutputs().get(0);
                if (modelOutput.getStatusCode() != null && modelOutput.getStatusCode().equals(200)) {
                    actionListener.onResponse((Object)new MLCancelBatchJobResponse(RestStatus.OK));
                } else {
                    log.debug("The status code from remote service is: {}", (Object)modelOutput.getStatusCode());
                    actionListener.onFailure((Exception)new SkyliteException("Couldn't cancel the transform job. Please try again", new Object[0]));
                }
            } else {
                log.debug("ML Model Outputs are null or empty.");
                actionListener.onFailure((Exception)new ResourceNotFoundException("Couldn't fetch status of the transform job", new Object[0]));
            }
        }
        catch (Exception e) {
            log.error("Unable to fetch status for ml task ", (Throwable)e);
        }
    }
}

