/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.tasks;

import io.lucenia.ml.common.action.handler.MLSearchHandler;
import io.lucenia.ml.common.transport.search.MLSearchActionRequest;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.client.Client;
import io.skylite.core.client.metadata.MetadataClient;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.index.query.BoolQueryBuilder;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.ml.common.cluster.TenantAwareHelper;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.index.query.QueryBuilders;

public class SearchTaskTransportAction
extends HandledTransportAction<MLSearchActionRequest, SearchResponse> {
    private static final Logger log = LogManager.getLogger(SearchTaskTransportAction.class);
    private Client client;
    private final MetadataClient sdkClient;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    @Inject
    public SearchTaskTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, MetadataClient sdkClient, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/lucenia/ml/tasks/search", transportService, actionFilters, MLSearchActionRequest::new);
        this.client = client;
        this.sdkClient = sdkClient;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    protected void doExecute(Task task, MLSearchActionRequest mlSearchActionRequest, ActionListener<SearchResponse> actionListener) {
        String tenantId = mlSearchActionRequest.getTenantId();
        if (!TenantAwareHelper.validateTenantId((MLFeatureEnabledSetting)this.mlFeatureEnabledSetting, (String)tenantId, actionListener)) {
            return;
        }
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener wrappedListener = ActionListenerHelper.wrap(arg_0 -> actionListener.onResponse(arg_0), e -> MLSearchHandler.wrapListenerToHandleSearchIndexNotFound(e, actionListener));
            if (tenantId != null) {
                BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
                if (mlSearchActionRequest.source().query() != null) {
                    queryBuilder.must(mlSearchActionRequest.source().query());
                }
                queryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"tenant_id", (String)tenantId));
                mlSearchActionRequest.source().query((QueryBuilder)queryBuilder);
            }
            this.client.search((SearchRequest)mlSearchActionRequest, ActionListenerHelper.runBefore((ActionListener)wrappedListener, () -> ((ThreadContext.StoredContext)context).restore()));
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            actionListener.onFailure(e2);
        }
    }
}

