/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.tools;

import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.ml.common.ToolMetadata;
import io.skylite.ml.common.transport.tools.MLToolGetRequest;
import io.skylite.ml.common.transport.tools.MLToolGetResponse;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GetToolTransportAction
extends HandledTransportAction<ActionRequest, MLToolGetResponse> {
    private static final Logger log = LogManager.getLogger(GetToolTransportAction.class);

    @Inject
    public GetToolTransportAction(TransportService transportService, ActionFilters actionFilters) {
        super("cluster:admin/lucenia/ml/tools/get", transportService, actionFilters, MLToolGetRequest::new);
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<MLToolGetResponse> listener) {
        MLToolGetRequest mlToolGetRequest = MLToolGetRequest.fromActionRequest((ActionRequest)request);
        String toolName = mlToolGetRequest.getToolName();
        try {
            List toolsList = mlToolGetRequest.getToolMetadataList();
            ToolMetadata theTool = toolsList.stream().filter(tool -> tool.getName().equals(toolName)).findFirst().orElseThrow(() -> new SkyliteStatusException("Failed to find tool information with the provided tool name: " + toolName, RestStatus.NOT_FOUND, new Object[0]));
            listener.onResponse((Object)MLToolGetResponse.builder().toolMetadata(theTool).build());
        }
        catch (Exception e) {
            log.error("Failed to get tool", (Throwable)e);
            listener.onFailure(e);
        }
    }
}

