/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.upload_chunk;

import io.lucenia.ml.common.engine.systemindices.MLIndicesHandler;
import io.lucenia.ml.common.model.ModelAccessControlHelper;
import io.lucenia.ml.common.rest.RestActionUtils;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.WriteRequest;
import io.skylite.core.action.get.GetRequest;
import io.skylite.core.action.get.GetResponse;
import io.skylite.core.action.index.IndexRequest;
import io.skylite.core.client.Client;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.security.auth.User;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.cluster.MLNodeUtils;
import io.skylite.ml.common.exception.MLExceptionUtils;
import io.skylite.ml.common.exception.MLResourceNotFoundException;
import io.skylite.ml.common.model.MLModel;
import io.skylite.ml.common.model.MLModelState;
import io.skylite.ml.common.transport.upload_chunk.MLUploadModelChunkInput;
import io.skylite.ml.common.transport.upload_chunk.MLUploadModelChunkResponse;
import java.util.Base64;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MLModelChunkUploader {
    private static final Logger log = LogManager.getLogger(MLModelChunkUploader.class);
    private final MLIndicesHandler mlIndicesHandler;
    private final Client client;
    private final NamedXContentRegistry xContentRegistry;
    ModelAccessControlHelper modelAccessControlHelper;

    @Inject
    public MLModelChunkUploader(MLIndicesHandler mlIndicesHandler, Client client, NamedXContentRegistry xContentRegistry, ModelAccessControlHelper modelAccessControlHelper) {
        this.mlIndicesHandler = mlIndicesHandler;
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.modelAccessControlHelper = modelAccessControlHelper;
    }

    public void uploadModelChunk(MLUploadModelChunkInput uploadModelChunkInput, ActionListener<MLUploadModelChunkResponse> listener) {
        String modelId = uploadModelChunkInput.getModelId();
        GetRequest getRequest = new GetRequest(".plugins-ml-model").id(modelId);
        User user = RestActionUtils.getUserContext(this.client);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener wrappedListener = ActionListenerHelper.runBefore(listener, () -> context.restore());
            this.client.get(getRequest, ActionListenerHelper.wrap(r -> {
                if (r != null && r.isExists()) {
                    try (XContentParser parser = MLNodeUtils.createXContentParserFromRegistry((NamedXContentRegistry)this.xContentRegistry, (BytesReference)r.getSourceAsBytesRef());){
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                        GetResponse getResponse = r;
                        String algorithmName = getResponse.getSource().get("algorithm").toString();
                        MLModel existingModel = MLModel.parse((XContentParser)parser, (String)algorithmName);
                        this.modelAccessControlHelper.validateModelGroupAccess(user, existingModel.getModelGroupId(), this.client, (ActionListener<Boolean>)ActionListenerHelper.wrap(access -> {
                            if (!access.booleanValue()) {
                                log.error("You don't have permissions to perform this operation on this model.");
                                wrappedListener.onFailure((Exception)new IllegalArgumentException("You don't have permissions to perform this operation on this model."));
                            } else {
                                existingModel.setModelId(r.getId());
                                if (existingModel.getTotalChunks() <= uploadModelChunkInput.getChunkNumber()) {
                                    throw new Exception("Chunk number exceeds total chunks");
                                }
                                byte[] bytes = uploadModelChunkInput.getContent();
                                if (bytes == null || bytes.length == 0) {
                                    throw new Exception("Chunk size either 0 or null");
                                }
                                if (this.validateChunkSize(bytes.length)) {
                                    throw new Exception("Chunk size exceeds 10MB");
                                }
                                this.mlIndicesHandler.initModelIndexIfAbsent((ActionListener<Boolean>)ActionListenerHelper.wrap(res -> {
                                    if (!res.booleanValue()) {
                                        wrappedListener.onFailure((Exception)new RuntimeException("No response to create ML Model index"));
                                        return;
                                    }
                                    int chunkNum = uploadModelChunkInput.getChunkNumber();
                                    MLModel mlModel = MLModel.builder().algorithm(existingModel.getAlgorithm()).modelGroupId(existingModel.getModelGroupId()).version(existingModel.getVersion()).modelId(existingModel.getModelId()).modelFormat(existingModel.getModelFormat()).totalChunks(existingModel.getTotalChunks()).algorithm(existingModel.getAlgorithm()).chunkNumber(Integer.valueOf(chunkNum)).content(Base64.getEncoder().encodeToString(bytes)).build();
                                    IndexRequest indexRequest = new IndexRequest(".plugins-ml-model");
                                    indexRequest.id(uploadModelChunkInput.getModelId() + "_" + uploadModelChunkInput.getChunkNumber());
                                    indexRequest.source(mlModel.toXContent(MediaTypeRegistry.JSON.contentBuilder(), ToXContent.EMPTY_PARAMS));
                                    indexRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                                    this.client.index(indexRequest, ActionListenerHelper.wrap(response -> {
                                        log.info("Index model successful for {} for chunk number {}", (Object)uploadModelChunkInput.getModelId(), (Object)(chunkNum + 1));
                                        if (existingModel.getTotalChunks() == uploadModelChunkInput.getChunkNumber() + 1) {
                                            Semaphore semaphore = new Semaphore(1);
                                            semaphore.acquire();
                                            MLModel mlModelMeta = MLModel.builder().name(existingModel.getName()).algorithm(existingModel.getAlgorithm()).version(existingModel.getVersion()).modelGroupId(existingModel.getModelGroupId()).modelFormat(existingModel.getModelFormat()).modelState(MLModelState.REGISTERED).modelConfig(existingModel.getModelConfig()).totalChunks(existingModel.getTotalChunks()).modelContentHash(existingModel.getModelContentHash()).modelContentSizeInBytes(existingModel.getModelContentSizeInBytes()).createdTime(existingModel.getCreatedTime()).build();
                                            IndexRequest indexReq = new IndexRequest(".plugins-ml-model");
                                            indexReq.id(modelId);
                                            indexReq.source(mlModelMeta.toXContent(MediaTypeRegistry.JSON.contentBuilder(), ToXContent.EMPTY_PARAMS));
                                            indexReq.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                                            this.client.index(indexReq, ActionListenerHelper.wrap(re -> {
                                                log.debug("Index model {} successful", (Object)existingModel.getName());
                                                semaphore.release();
                                            }, e -> {
                                                log.error("Failed to update model state", (Throwable)e);
                                                semaphore.release();
                                                wrappedListener.onFailure(e);
                                            }));
                                        }
                                        wrappedListener.onResponse((Object)new MLUploadModelChunkResponse("Uploaded"));
                                    }, e -> {
                                        log.error("Failed to upload chunk model", (Throwable)e);
                                        wrappedListener.onFailure(e);
                                    }));
                                }, ex -> {
                                    log.error("Failed to init model index", (Throwable)ex);
                                    wrappedListener.onFailure(ex);
                                }));
                            }
                        }, e -> {
                            MLExceptionUtils.logException((String)"Failed to validate model access", (Exception)e, (Logger)log);
                            wrappedListener.onFailure(e);
                        }));
                    }
                    catch (Exception e2) {
                        log.error("Failed to parse ml model " + r.getId(), (Throwable)e2);
                        wrappedListener.onFailure(e2);
                    }
                } else {
                    wrappedListener.onFailure((Exception)new MLResourceNotFoundException("Failed to find model"));
                }
            }, e -> {
                if (e instanceof IndexNotFoundException) {
                    wrappedListener.onFailure((Exception)new MLResourceNotFoundException("Failed to find model"));
                } else {
                    log.error("Failed to get ML model " + modelId, (Throwable)e);
                    wrappedListener.onFailure(e);
                }
            }));
        }
        catch (Exception e2) {
            log.error("Fail to upload chunk for model " + modelId, (Throwable)e2);
            listener.onFailure(e2);
        }
    }

    public boolean validateChunkSize(long length) {
        boolean isChunkExceedsSize = false;
        if (length > 10000000L) {
            isChunkExceedsSize = true;
        }
        return isChunkExceedsSize;
    }
}

