/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.upload_chunk;

import io.lucenia.ml.common.model.MLModelGroupManager;
import io.lucenia.ml.common.model.MLModelManager;
import io.lucenia.ml.common.model.ModelAccessControlHelper;
import io.lucenia.ml.common.rest.RestActionUtils;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.client.Client;
import io.skylite.core.common.Strings;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.security.auth.User;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.ml.common.exception.MLExceptionUtils;
import io.skylite.ml.common.task.MLTaskState;
import io.skylite.ml.common.transport.model_group.MLRegisterModelGroupInput;
import io.skylite.ml.common.transport.upload_chunk.MLRegisterModelMetaInput;
import io.skylite.ml.common.transport.upload_chunk.MLRegisterModelMetaRequest;
import io.skylite.ml.common.transport.upload_chunk.MLRegisterModelMetaResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransportRegisterModelMetaAction
extends HandledTransportAction<ActionRequest, MLRegisterModelMetaResponse> {
    private static final Logger log = LogManager.getLogger(TransportRegisterModelMetaAction.class);
    TransportService transportService;
    ActionFilters actionFilters;
    MLModelManager mlModelManager;
    Client client;
    ModelAccessControlHelper modelAccessControlHelper;
    MLModelGroupManager mlModelGroupManager;

    @Inject
    public TransportRegisterModelMetaAction(TransportService transportService, ActionFilters actionFilters, MLModelManager mlModelManager, Client client, ModelAccessControlHelper modelAccessControlHelper, MLModelGroupManager mlModelGroupManager) {
        super("cluster:admin/lucenia/ml/register_model_meta", transportService, actionFilters, MLRegisterModelMetaRequest::new);
        this.transportService = transportService;
        this.actionFilters = actionFilters;
        this.mlModelManager = mlModelManager;
        this.client = client;
        this.modelAccessControlHelper = modelAccessControlHelper;
        this.mlModelGroupManager = mlModelGroupManager;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<MLRegisterModelMetaResponse> listener) {
        MLRegisterModelMetaRequest registerModelMetaRequest = MLRegisterModelMetaRequest.fromActionRequest((ActionRequest)request);
        MLRegisterModelMetaInput mlUploadInput = registerModelMetaRequest.getMlRegisterModelMetaInput();
        if (Strings.isEmpty((CharSequence)mlUploadInput.getModelGroupId())) {
            this.mlModelGroupManager.validateUniqueModelGroupName(mlUploadInput.getName(), null, (ActionListener<SearchResponse>)ActionListenerHelper.wrap(modelGroups -> {
                if (modelGroups != null && modelGroups.getHits().getTotalHits() != null && modelGroups.getHits().getTotalHits().value() != 0L) {
                    String modelGroupIdOfTheNameProvided = modelGroups.getHits().getAt(0).getId();
                    mlUploadInput.setModelGroupId(modelGroupIdOfTheNameProvided);
                    this.checkUserAccess(mlUploadInput, listener, true);
                } else {
                    this.createModelGroup(mlUploadInput, listener);
                }
            }, e -> {
                log.error("Failed to search model group index", (Throwable)e);
                listener.onFailure(e);
            }));
        } else {
            this.checkUserAccess(mlUploadInput, listener, false);
        }
    }

    private void checkUserAccess(MLRegisterModelMetaInput mlUploadInput, ActionListener<MLRegisterModelMetaResponse> listener, Boolean isModelNameAlreadyExisting) {
        User user = RestActionUtils.getUserContext(this.client);
        this.modelAccessControlHelper.validateModelGroupAccess(user, mlUploadInput.getModelGroupId(), this.client, (ActionListener<Boolean>)ActionListenerHelper.wrap(access -> {
            if (access.booleanValue()) {
                this.createModelGroup(mlUploadInput, listener);
                return;
            }
            if (isModelNameAlreadyExisting.booleanValue()) {
                listener.onFailure((Exception)new IllegalArgumentException("The name {" + mlUploadInput.getName() + "} you provided is unavailable because it is used by another model group with id {" + mlUploadInput.getModelGroupId() + "} to which you do not have access. Please provide a different name."));
            } else {
                log.error("You don't have permissions to perform this operation on this model.");
                listener.onFailure((Exception)new IllegalArgumentException("You don't have permissions to perform this operation on this model."));
            }
        }, e -> {
            MLExceptionUtils.logException((String)"Failed to validate model access", (Exception)e, (Logger)log);
            listener.onFailure(e);
        }));
    }

    private void createModelGroup(MLRegisterModelMetaInput mlUploadInput, ActionListener<MLRegisterModelMetaResponse> listener) {
        if (Strings.isEmpty((CharSequence)mlUploadInput.getModelGroupId())) {
            MLRegisterModelGroupInput mlRegisterModelGroupInput = this.createRegisterModelGroupRequest(mlUploadInput);
            this.mlModelGroupManager.createModelGroup(mlRegisterModelGroupInput, (ActionListener<String>)ActionListenerHelper.wrap(modelGroupId -> {
                mlUploadInput.setModelGroupId(modelGroupId);
                mlUploadInput.setDoesVersionCreateModelGroup(Boolean.valueOf(true));
                this.registerModelMeta(mlUploadInput, listener);
            }, e -> {
                MLExceptionUtils.logException((String)"Failed to create Model Group", (Exception)e, (Logger)log);
                listener.onFailure(e);
            }));
        } else {
            mlUploadInput.setDoesVersionCreateModelGroup(Boolean.valueOf(false));
            this.registerModelMeta(mlUploadInput, listener);
        }
    }

    private MLRegisterModelGroupInput createRegisterModelGroupRequest(MLRegisterModelMetaInput mlUploadInput) {
        return MLRegisterModelGroupInput.builder().name(mlUploadInput.getName()).description(mlUploadInput.getDescription()).backendRoles(mlUploadInput.getBackendRoles()).modelAccessMode(mlUploadInput.getAccessMode()).isAddAllBackendRoles(mlUploadInput.getIsAddAllBackendRoles()).build();
    }

    private void registerModelMeta(MLRegisterModelMetaInput mlUploadInput, ActionListener<MLRegisterModelMetaResponse> listener) {
        this.mlModelManager.registerModelMeta(mlUploadInput, (ActionListener<String>)ActionListenerHelper.wrap(modelId -> listener.onResponse((Object)new MLRegisterModelMetaResponse(modelId, MLTaskState.CREATED.name())), ex -> {
            log.error("Failed to init model index", (Throwable)ex);
            listener.onFailure(ex);
        }));
    }
}

