/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.cluster;

import io.lucenia.ml.common.autoredeploy.MLModelAutoReDeployer;
import io.lucenia.ml.common.model.MLModelManager;
import io.lucenia.ml.common.task.MLTaskManager;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.node.DiscoveryNodes;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.ClusterStateChangedEvent;
import io.skylite.core.cluster.state.ClusterStateListener;
import io.skylite.core.settings.Settings;
import io.skylite.ml.common.model.MLModelCacheHelper;
import io.skylite.ml.common.settings.MLCommonsSettings;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MLCommonsClusterEventListener
implements ClusterStateListener {
    private static final Logger log = LogManager.getLogger(MLCommonsClusterEventListener.class);
    private final ClusterService clusterService;
    private final MLModelManager mlModelManager;
    private final MLTaskManager mlTaskManager;
    private final MLModelCacheHelper modelCacheHelper;
    private final MLModelAutoReDeployer mlModelAutoReDeployer;

    public MLCommonsClusterEventListener(ClusterService clusterService, MLModelManager mlModelManager, MLTaskManager mlTaskManager, MLModelCacheHelper modelCacheHelper, MLModelAutoReDeployer mlModelAutoReDeployer) {
        this.clusterService = clusterService;
        this.clusterService.addListener((ClusterStateListener)this);
        this.mlModelManager = mlModelManager;
        this.mlTaskManager = mlTaskManager;
        this.modelCacheHelper = modelCacheHelper;
        this.mlModelAutoReDeployer = mlModelAutoReDeployer;
    }

    public void clusterChanged(ClusterStateChangedEvent event) {
        DiscoveryNodes.Delta delta;
        long monitoringReqCount;
        ClusterState previousState = event.previousState();
        ClusterState state = event.state();
        Settings previousSettings = previousState.getMetadata().settings();
        Settings settings = state.getMetadata().settings();
        long previousMonitoringReqCount = (Long)MLCommonsSettings.ML_COMMONS_MONITORING_REQUEST_COUNT.get(previousSettings);
        if (previousMonitoringReqCount > (monitoringReqCount = ((Long)MLCommonsSettings.ML_COMMONS_MONITORING_REQUEST_COUNT.get(settings)).longValue())) {
            this.modelCacheHelper.resizeMonitoringQueue(monitoringReqCount);
        }
        if ((delta = event.nodesDelta()).removed()) {
            Set<String> removedNodeIds = delta.removedNodes().stream().map(DiscoveryNode::getId).collect(Collectors.toSet());
            this.mlModelManager.removeWorkerNodes(removedNodeIds, false);
        } else if (delta.added()) {
            List<String> addedNodesIds = delta.addedNodes().stream().map(DiscoveryNode::getId).collect(Collectors.toList());
            this.mlModelAutoReDeployer.buildAutoReloadArrangement(addedNodesIds, state.getNodes().getClusterManagerNodeId());
        }
    }
}

