/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.conversation;

import io.skylite.ResourceAlreadyExistsException;
import io.skylite.ResourceNotFoundException;
import io.skylite.SkyliteStatusException;
import io.skylite.SkyliteWrapperException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.DocWriteResponse;
import io.skylite.core.action.admin.indices.create.CreateIndexRequest;
import io.skylite.core.action.admin.indices.create.CreateIndexResponse;
import io.skylite.core.action.admin.indices.refresh.RefreshRequest;
import io.skylite.core.action.delete.DeleteRequest;
import io.skylite.core.action.get.GetRequest;
import io.skylite.core.action.index.IndexRequest;
import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.action.update.UpdateRequest;
import io.skylite.core.action.update.UpdateResponse;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.index.query.BoolQueryBuilder;
import io.skylite.core.index.query.MatchAllQueryBuilder;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.index.query.TermQueryBuilder;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.search.SearchHit;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.search.sort.SortOrder;
import io.skylite.core.security.auth.User;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.ml.common.conversation.ConversationMeta;
import io.skylite.ml.common.conversation.ConversationalIndexConstants;
import io.skylite.ml.common.utils.IndexUtils;
import java.io.IOException;
import java.time.Instant;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConversationMetaIndex {
    private static final Logger log = LogManager.getLogger(ConversationMetaIndex.class);
    private Client client;
    private ClusterService clusterService;

    public ConversationMetaIndex(Client client, ClusterService clusterService) {
        this.client = client;
        this.clusterService = clusterService;
    }

    private String getUserStrFromThreadContext() {
        return (String)this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info");
    }

    public void initConversationMetaIndexIfAbsent(ActionListener<Boolean> listener) {
        block11: {
            if (!this.clusterService.state().metadata().hasIndex(ConversationalIndexConstants.META_INDEX_NAME)) {
                log.debug("No conversational meta index found. Adding it");
                CreateIndexRequest request = new CreateIndexRequest(ConversationalIndexConstants.META_INDEX_NAME).mapping(ConversationalIndexConstants.META_MAPPING, MediaTypeRegistry.JSON).settings(IndexUtils.DEFAULT_INDEX_SETTINGS);
                try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
                    ActionListener internalListener = ActionListenerHelper.runBefore(listener, () -> threadContext.restore());
                    ActionListener al = ActionListenerHelper.wrap(createIndexResponse -> {
                        if (createIndexResponse.equals((Object)new CreateIndexResponse(true, true, ConversationalIndexConstants.META_INDEX_NAME))) {
                            log.info("created index [" + ConversationalIndexConstants.META_INDEX_NAME + "]");
                            internalListener.onResponse((Object)true);
                        } else {
                            internalListener.onResponse((Object)false);
                        }
                    }, e -> {
                        if (e instanceof ResourceAlreadyExistsException || e instanceof SkyliteWrapperException && e.getCause() instanceof ResourceAlreadyExistsException) {
                            internalListener.onResponse((Object)true);
                        } else {
                            log.error("failed to create index [" + ConversationalIndexConstants.META_INDEX_NAME + "]", (Throwable)e);
                            internalListener.onFailure(e);
                        }
                    });
                    this.client.admin().indices().create(request, al);
                }
                catch (Exception e2) {
                    if (e2 instanceof ResourceAlreadyExistsException || e2 instanceof SkyliteWrapperException && e2.getCause() instanceof ResourceAlreadyExistsException) {
                        listener.onResponse((Object)true);
                        break block11;
                    }
                    log.error("failed to create index [" + ConversationalIndexConstants.META_INDEX_NAME + "]", (Throwable)e2);
                    listener.onFailure(e2);
                }
            } else {
                listener.onResponse((Object)true);
            }
        }
    }

    public void createConversation(String name, String applicationType, Map<String, String> additionalInfos, ActionListener<String> listener) {
        this.initConversationMetaIndexIfAbsent((ActionListener<Boolean>)ActionListenerHelper.wrap(indexExists -> {
            if (indexExists.booleanValue()) {
                String userStr = this.getUserStrFromThreadContext();
                Instant now = Instant.now();
                HashMap<String, Object> sourceMap = new HashMap<String, Object>();
                sourceMap.put("create_time", now);
                sourceMap.put("updated_time", now);
                if (name != null && !name.trim().isEmpty()) {
                    sourceMap.put("name", name);
                }
                if (userStr != null && !userStr.trim().isEmpty()) {
                    sourceMap.put("user", User.parse((String)userStr).getName());
                }
                if (applicationType != null && !applicationType.trim().isEmpty()) {
                    sourceMap.put("application_type", applicationType);
                }
                if (additionalInfos != null && !additionalInfos.isEmpty()) {
                    sourceMap.put("additional_info", additionalInfos);
                }
                IndexRequest request = new IndexRequest(ConversationalIndexConstants.META_INDEX_NAME).source(sourceMap);
                try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
                    ActionListener internalListener = ActionListenerHelper.runBefore((ActionListener)listener, () -> threadContext.restore());
                    ActionListener al = ActionListenerHelper.wrap(resp -> {
                        if (resp.status() == RestStatus.CREATED) {
                            internalListener.onResponse((Object)resp.getId());
                            log.info("Successfully created the memory with id : {}", (Object)resp.getId());
                        } else {
                            internalListener.onFailure((Exception)new IOException("failed to create memory"));
                        }
                    }, e -> {
                        log.error("Failed to create memory", (Throwable)e);
                        internalListener.onFailure(e);
                    });
                    this.client.index(request, al);
                }
                catch (Exception e2) {
                    log.error("Failed to create memory", (Throwable)e2);
                    listener.onFailure(e2);
                }
            } else {
                listener.onFailure((Exception)new IOException("Failed to add memory due to missing index"));
            }
        }, e -> listener.onFailure(e)));
    }

    public void createConversation(ActionListener<String> listener) {
        this.createConversation("", "", null, listener);
    }

    public void createConversation(String name, ActionListener<String> listener) {
        this.createConversation(name, "", null, listener);
    }

    public void getConversations(int from, int maxResults, ActionListener<List<ConversationMeta>> listener) {
        if (!this.clusterService.state().metadata().hasIndex(ConversationalIndexConstants.META_INDEX_NAME)) {
            listener.onResponse(List.of());
            return;
        }
        SearchRequest request = new SearchRequest(new String[]{ConversationalIndexConstants.META_INDEX_NAME});
        String userStr = this.getUserStrFromThreadContext();
        Object queryBuilder = userStr == null ? new MatchAllQueryBuilder() : new TermQueryBuilder("user", User.parse((String)userStr).getName());
        request.source().query((QueryBuilder)queryBuilder);
        request.source().from(from).size(maxResults);
        request.source().sort("updated_time", SortOrder.DESC);
        try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener internalListener = ActionListenerHelper.runBefore(listener, () -> threadContext.restore());
            ActionListener al = ActionListenerHelper.wrap(searchResponse -> {
                LinkedList<ConversationMeta> result = new LinkedList<ConversationMeta>();
                for (SearchHit hit : searchResponse.getHits()) {
                    result.add(ConversationMeta.fromSearchHit((SearchHit)hit));
                }
                internalListener.onResponse(result);
                log.info("Successfully retrieved memories");
            }, e -> {
                log.error("Failed to retrieve memories", (Throwable)e);
                internalListener.onFailure(e);
            });
            this.client.admin().indices().refresh(new RefreshRequest(new String[]{ConversationalIndexConstants.META_INDEX_NAME}), ActionListenerHelper.wrap(refreshResponse -> this.client.search(request, al), e -> {
                log.error("Failed to retrieve memories during refresh", (Throwable)e);
                internalListener.onFailure(e);
            }));
        }
        catch (Exception e2) {
            log.error("Failed to retrieve memories", (Throwable)e2);
            listener.onFailure(e2);
        }
    }

    public void getConversations(int maxResults, ActionListener<List<ConversationMeta>> listener) {
        this.getConversations(0, maxResults, listener);
    }

    public void deleteConversation(String conversationId, ActionListener<Boolean> listener) {
        if (!this.clusterService.state().metadata().hasIndex(ConversationalIndexConstants.META_INDEX_NAME)) {
            listener.onResponse((Object)true);
            return;
        }
        DeleteRequest delRequest = new DeleteRequest(ConversationalIndexConstants.META_INDEX_NAME).id(conversationId);
        String userStr = this.getUserStrFromThreadContext();
        String user = User.parse((String)userStr) == null ? "BAD_USER" : User.parse((String)userStr).getName();
        this.checkAccess(conversationId, (ActionListener<Boolean>)ActionListenerHelper.wrap(access -> {
            if (access.booleanValue()) {
                try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
                    ActionListener internalListener = ActionListenerHelper.runBefore((ActionListener)listener, () -> threadContext.restore());
                    ActionListener al = ActionListenerHelper.wrap(deleteResponse -> {
                        if (deleteResponse.getResult() == DocWriteResponse.Result.DELETED) {
                            internalListener.onResponse((Object)true);
                        } else if (deleteResponse.status() == RestStatus.NOT_FOUND) {
                            internalListener.onResponse((Object)true);
                        } else {
                            internalListener.onResponse((Object)false);
                        }
                    }, e -> {
                        log.error("Failure deleting memory with ID" + conversationId, (Throwable)e);
                        internalListener.onFailure(e);
                    });
                    this.client.delete(delRequest, al);
                }
                catch (Exception e2) {
                    log.error("Failed deleting memory with id=" + conversationId, (Throwable)e2);
                    listener.onFailure(e2);
                }
            } else {
                throw new SkyliteStatusException("User [" + user + "] does not have access to memory " + conversationId, RestStatus.UNAUTHORIZED, new Object[0]);
            }
        }, e -> listener.onFailure(e)));
    }

    public void checkAccess(String conversationId, ActionListener<Boolean> listener) {
        if (!this.clusterService.state().metadata().hasIndex(ConversationalIndexConstants.META_INDEX_NAME)) {
            listener.onResponse((Object)true);
            return;
        }
        String userStr = this.getUserStrFromThreadContext();
        try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener internalListener = ActionListenerHelper.runBefore(listener, () -> threadContext.restore());
            GetRequest getRequest = new GetRequest(ConversationalIndexConstants.META_INDEX_NAME).id(conversationId);
            ActionListener al = ActionListenerHelper.wrap(getResponse -> {
                if (!getResponse.isExists() || !getResponse.getId().equals(conversationId)) {
                    throw new ResourceNotFoundException("Memory [" + conversationId + "] not found", new Object[0]);
                }
                if (userStr == null || User.parse((String)userStr) == null) {
                    internalListener.onResponse((Object)true);
                    return;
                }
                ConversationMeta conversation = ConversationMeta.fromMap((String)conversationId, (Map)getResponse.getSourceAsMap());
                String user = User.parse((String)userStr).getName();
                if (!user.equals(conversation.getUser())) {
                    internalListener.onResponse((Object)false);
                    return;
                }
                internalListener.onResponse((Object)true);
            }, e -> internalListener.onFailure(e));
            this.client.admin().indices().refresh(new RefreshRequest(new String[]{ConversationalIndexConstants.META_INDEX_NAME}), ActionListenerHelper.wrap(refreshResponse -> this.client.get(getRequest, al), e -> {
                log.error("Failed to refresh memory index during check access ", (Throwable)e);
                internalListener.onFailure(e);
            }));
        }
        catch (Exception e2) {
            listener.onFailure(e2);
        }
    }

    public void searchConversations(SearchRequest request, ActionListener<SearchResponse> listener) {
        request.indices(new String[]{ConversationalIndexConstants.META_INDEX_NAME});
        QueryBuilder originalQuery = request.source().query();
        BoolQueryBuilder newQuery = new BoolQueryBuilder();
        newQuery.must(originalQuery);
        String userStr = this.getUserStrFromThreadContext();
        if (userStr != null) {
            String user = User.parse((String)userStr) == null ? "BAD_USER" : User.parse((String)userStr).getName();
            newQuery.must((QueryBuilder)new TermQueryBuilder("user", user));
        }
        request.source().query((QueryBuilder)newQuery);
        try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener internalListener = ActionListenerHelper.runBefore(listener, () -> threadContext.restore());
            this.client.admin().indices().refresh(new RefreshRequest(new String[]{ConversationalIndexConstants.META_INDEX_NAME}), ActionListenerHelper.wrap(refreshResponse -> this.client.search(request, internalListener), e -> {
                log.error("Failed to refresh memory index during search memories ", (Throwable)e);
                internalListener.onFailure(e);
            }));
        }
        catch (Exception e2) {
            listener.onFailure(e2);
        }
    }

    public void updateConversation(String conversationId, UpdateRequest updateRequest, ActionListener<UpdateResponse> listener) {
        if (!this.clusterService.state().metadata().hasIndex(ConversationalIndexConstants.META_INDEX_NAME)) {
            listener.onFailure((Exception)new IndexNotFoundException("cannot update memory since the memory index does not exist", ConversationalIndexConstants.META_INDEX_NAME));
            return;
        }
        this.checkAccess(conversationId, (ActionListener<Boolean>)ActionListenerHelper.wrap(access -> {
            if (!access.booleanValue()) {
                String userStr = (String)this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info");
                String user = User.parse((String)userStr) == null ? "BAD_USER" : User.parse((String)userStr).getName();
                throw new SkyliteStatusException("User [" + user + "] does not have access to memory " + conversationId, RestStatus.UNAUTHORIZED, new Object[0]);
            }
            this.innerUpdateConversation(updateRequest, listener);
        }, e -> listener.onFailure(e)));
    }

    private void innerUpdateConversation(UpdateRequest updateRequest, ActionListener<UpdateResponse> listener) {
        try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener internalListener = ActionListenerHelper.runBefore(listener, () -> threadContext.restore());
            this.client.update(updateRequest, internalListener);
        }
        catch (Exception e) {
            log.error("Failed to update Memory");
            listener.onFailure(e);
        }
    }

    public void getConversation(String conversationId, ActionListener<ConversationMeta> listener) {
        if (!this.clusterService.state().metadata().hasIndex(ConversationalIndexConstants.META_INDEX_NAME)) {
            listener.onFailure((Exception)new IndexNotFoundException("cannot get memory since the memory index does not exist", ConversationalIndexConstants.META_INDEX_NAME));
            return;
        }
        String userStr = this.getUserStrFromThreadContext();
        try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener internalListener = ActionListenerHelper.runBefore(listener, () -> threadContext.restore());
            GetRequest request = new GetRequest(ConversationalIndexConstants.META_INDEX_NAME).id(conversationId);
            ActionListener al = ActionListenerHelper.wrap(getResponse -> {
                String user;
                if (!getResponse.isExists() || !getResponse.getId().equals(conversationId)) {
                    throw new ResourceNotFoundException("Memory [" + conversationId + "] not found", new Object[0]);
                }
                ConversationMeta conversation = ConversationMeta.fromMap((String)conversationId, (Map)getResponse.getSourceAsMap());
                if (userStr == null || User.parse((String)userStr) == null) {
                    internalListener.onResponse((Object)conversation);
                    return;
                }
                String string = user = User.parse((String)userStr) == null ? "BAD_USER" : User.parse((String)userStr).getName();
                if (user.equals(conversation.getUser())) {
                    internalListener.onResponse((Object)conversation);
                    log.info("Successfully get the memory for {}", (Object)conversationId);
                    return;
                }
                internalListener.onFailure((Exception)new SkyliteStatusException("User [" + user + "] does not have access to memory " + conversationId, RestStatus.UNAUTHORIZED, new Object[0]));
            }, e -> internalListener.onFailure(e));
            this.client.admin().indices().refresh(new RefreshRequest(new String[]{ConversationalIndexConstants.META_INDEX_NAME}), ActionListenerHelper.wrap(refreshResponse -> this.client.get(request, al), e -> {
                log.error("Failed to refresh the memory index during get memory ", (Throwable)e);
                internalListener.onFailure(e);
            }));
        }
        catch (Exception e2) {
            listener.onFailure(e2);
        }
    }
}

