/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.conversation;

import io.lucenia.ml.common.conversation.ConversationMetaIndex;
import io.lucenia.ml.common.conversation.InteractionsIndex;
import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionFuture;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.StepListener;
import io.skylite.core.action.WriteRequest;
import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.action.support.PlainActionFuture;
import io.skylite.core.action.update.UpdateRequest;
import io.skylite.core.action.update.UpdateResponse;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.search.SearchRequest;
import io.skylite.ml.common.conversation.ConversationMeta;
import io.skylite.ml.common.conversation.ConversationalIndexConstants;
import io.skylite.ml.common.conversation.ConversationalMemoryHandler;
import io.skylite.ml.common.conversation.Interaction;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConversationalSearchService
implements ConversationalMemoryHandler {
    private static final Logger log = LogManager.getLogger(ConversationalSearchService.class);
    private ConversationMetaIndex conversationMetaIndex;
    private InteractionsIndex interactionsIndex;

    public ConversationalSearchService(Client client, ClusterService clusterService) {
        this.conversationMetaIndex = new ConversationMetaIndex(client, clusterService);
        this.interactionsIndex = new InteractionsIndex(client, clusterService, this.conversationMetaIndex);
    }

    public ConversationalSearchService(ConversationMetaIndex conversationMetaIndex, InteractionsIndex interactionsIndex) {
        this.conversationMetaIndex = conversationMetaIndex;
        this.interactionsIndex = interactionsIndex;
    }

    public void createConversation(ActionListener<String> listener) {
        this.conversationMetaIndex.createConversation(listener);
    }

    public ActionFuture<String> createConversation() {
        PlainActionFuture fut = PlainActionFuture.newFuture();
        this.createConversation((ActionListener<String>)fut);
        return fut;
    }

    public void createConversation(String name, ActionListener<String> listener) {
        this.conversationMetaIndex.createConversation(name, listener);
    }

    public void createConversation(String name, String applicationType, ActionListener<String> listener) {
        this.conversationMetaIndex.createConversation(name, applicationType, null, listener);
    }

    public void createConversation(String name, String applicationType, Map<String, String> additionalInfos, ActionListener<String> listener) {
        this.conversationMetaIndex.createConversation(name, applicationType, additionalInfos, listener);
    }

    public ActionFuture<String> createConversation(String name) {
        PlainActionFuture fut = PlainActionFuture.newFuture();
        this.createConversation(name, (ActionListener<String>)fut);
        return fut;
    }

    public void createInteraction(String conversationId, String input, String promptTemplate, String response, String origin, Map<String, String> additionalInfo, ActionListener<String> listener) {
        Instant time = Instant.now();
        this.interactionsIndex.createInteraction(conversationId, input, promptTemplate, response, origin, additionalInfo, time, listener);
    }

    public void createInteraction(String conversationId, String input, String promptTemplate, String response, String origin, Map<String, String> additionalInfo, ActionListener<String> listener, String interactionId, Integer traceNumber) {
        Instant time = Instant.now();
        this.interactionsIndex.createInteraction(conversationId, input, promptTemplate, response, origin, additionalInfo, time, listener, interactionId, traceNumber);
    }

    public ActionFuture<String> createInteraction(String conversationId, String input, String promptTemplate, String response, String origin, Map<String, String> additionalInfo) {
        PlainActionFuture fut = PlainActionFuture.newFuture();
        this.createInteraction(conversationId, input, promptTemplate, response, origin, additionalInfo, (ActionListener<String>)fut);
        return fut;
    }

    public void createInteraction(Interaction.Builder builder, ActionListener<String> listener) {
        builder.createTime(Instant.now());
        Interaction interaction = builder.build();
        this.interactionsIndex.createInteraction(interaction.getConversationId(), interaction.getInput(), interaction.getPromptTemplate(), interaction.getResponse(), interaction.getOrigin(), interaction.getAdditionalInfo(), interaction.getCreateTime(), listener);
    }

    public ActionFuture<String> createInteraction(Interaction.Builder builder) {
        PlainActionFuture fut = PlainActionFuture.newFuture();
        this.createInteraction(builder, (ActionListener<String>)fut);
        return fut;
    }

    public void getInteractions(String conversationId, int from, int maxResults, ActionListener<List<Interaction>> listener) {
        this.interactionsIndex.getInteractions(conversationId, from, maxResults, listener);
    }

    public ActionFuture<List<Interaction>> getInteractions(String conversationId, int from, int maxResults) {
        PlainActionFuture fut = PlainActionFuture.newFuture();
        this.getInteractions(conversationId, from, maxResults, (ActionListener<List<Interaction>>)fut);
        return fut;
    }

    public void getConversations(int from, int maxResults, ActionListener<List<ConversationMeta>> listener) {
        this.conversationMetaIndex.getConversations(from, maxResults, listener);
    }

    public ActionFuture<List<ConversationMeta>> getConversations(int from, int maxResults) {
        PlainActionFuture fut = PlainActionFuture.newFuture();
        this.getConversations(from, maxResults, (ActionListener<List<ConversationMeta>>)fut);
        return fut;
    }

    public void getConversations(int maxResults, ActionListener<List<ConversationMeta>> listener) {
        this.conversationMetaIndex.getConversations(maxResults, listener);
    }

    public ActionFuture<List<ConversationMeta>> getConversations(int maxResults) {
        PlainActionFuture fut = PlainActionFuture.newFuture();
        this.getConversations(maxResults, (ActionListener<List<ConversationMeta>>)fut);
        return fut;
    }

    public void deleteConversation(String conversationId, ActionListener<Boolean> listener) {
        StepListener accessListener = new StepListener();
        this.conversationMetaIndex.checkAccess(conversationId, (ActionListener<Boolean>)accessListener);
        accessListener.whenComplete(access -> {
            if (access.booleanValue()) {
                StepListener metaDeleteListener = new StepListener();
                StepListener interactionsListener = new StepListener();
                this.interactionsIndex.deleteConversation(conversationId, (ActionListener<Boolean>)interactionsListener);
                interactionsListener.whenComplete(interactionResult -> this.conversationMetaIndex.deleteConversation(conversationId, (ActionListener<Boolean>)metaDeleteListener), arg_0 -> ((ActionListener)listener).onFailure(arg_0));
                metaDeleteListener.whenComplete(metaDeleteResult -> {
                    log.info("Successful deletion of memory " + conversationId);
                    listener.onResponse((Object)(metaDeleteResult != false && (Boolean)interactionsListener.result() != false ? 1 : 0));
                }, arg_0 -> ((ActionListener)listener).onFailure(arg_0));
            } else {
                log.error("No access to delete the memory for " + conversationId);
                listener.onFailure((Exception)new SkyliteStatusException("Resources not found. Failed to delete the memory for " + conversationId, RestStatus.NOT_FOUND, new Object[0]));
            }
        }, arg_0 -> listener.onFailure(arg_0));
    }

    public ActionFuture<Boolean> deleteConversation(String conversationId) {
        PlainActionFuture fut = PlainActionFuture.newFuture();
        this.deleteConversation(conversationId, (ActionListener<Boolean>)fut);
        return fut;
    }

    public void searchConversations(SearchRequest request, ActionListener<SearchResponse> listener) {
        this.conversationMetaIndex.searchConversations(request, listener);
    }

    public ActionFuture<SearchResponse> searchConversations(SearchRequest request) {
        PlainActionFuture fut = PlainActionFuture.newFuture();
        this.searchConversations(request, (ActionListener<SearchResponse>)fut);
        return fut;
    }

    public void searchInteractions(String conversationId, SearchRequest request, ActionListener<SearchResponse> listener) {
        this.interactionsIndex.searchInteractions(conversationId, request, listener);
    }

    public ActionFuture<SearchResponse> searchInteractions(String conversationId, SearchRequest request) {
        PlainActionFuture fut = PlainActionFuture.newFuture();
        this.searchInteractions(conversationId, request, (ActionListener<SearchResponse>)fut);
        return fut;
    }

    public void getTraces(String interactionId, int from, int maxResults, ActionListener<List<Interaction>> listener) {
        this.interactionsIndex.getTraces(interactionId, from, maxResults, listener);
    }

    public void updateConversation(String conversationId, Map<String, Object> updateContent, ActionListener<UpdateResponse> listener) {
        UpdateRequest updateRequest = new UpdateRequest(ConversationalIndexConstants.META_INDEX_NAME, conversationId);
        updateContent.putIfAbsent("updated_time", Instant.now());
        updateRequest.doc(updateContent);
        updateRequest.docAsUpsert(true);
        updateRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        this.conversationMetaIndex.updateConversation(conversationId, updateRequest, listener);
    }

    public void updateInteraction(String interactionId, Map<String, Object> updateContent, ActionListener<UpdateResponse> listener) {
        UpdateRequest updateRequest = new UpdateRequest(ConversationalIndexConstants.INTERACTIONS_INDEX_NAME, interactionId);
        updateRequest.doc(updateContent);
        updateRequest.docAsUpsert(true);
        updateRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        this.interactionsIndex.updateInteraction(interactionId, updateRequest, listener);
    }

    public void getConversation(String conversationId, ActionListener<ConversationMeta> listener) {
        this.conversationMetaIndex.getConversation(conversationId, listener);
    }

    public ActionFuture<ConversationMeta> getConversation(String conversationId) {
        PlainActionFuture fut = PlainActionFuture.newFuture();
        this.getConversation(conversationId, (ActionListener<ConversationMeta>)fut);
        return fut;
    }

    public void getInteraction(String interactionId, ActionListener<Interaction> listener) {
        this.interactionsIndex.getInteraction(interactionId, listener);
    }

    public ActionFuture<Interaction> getInteraction(String interactionId) {
        PlainActionFuture fut = PlainActionFuture.newFuture();
        this.getInteraction(interactionId, (ActionListener<Interaction>)fut);
        return fut;
    }
}

