/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.engine.algorithms.agent;

import io.lucenia.ml.common.engine.algorithms.agent.AgentUtils;
import io.lucenia.ml.common.engine.memory.ConversationIndexMemory;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.StepListener;
import io.skylite.core.action.update.UpdateResponse;
import io.skylite.core.client.ReleasableSkyliteClient;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.Strings;
import io.skylite.core.settings.Settings;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.ml.common.agent.MLAgent;
import io.skylite.ml.common.agent.MLMemorySpec;
import io.skylite.ml.common.agent.MLToolSpec;
import io.skylite.ml.common.algorithms.agent.MLAgentRunner;
import io.skylite.ml.common.engine.memory.Memory;
import io.skylite.ml.common.engine.tools.Tool;
import io.skylite.ml.common.output.model.ModelTensor;
import io.skylite.ml.common.output.model.ModelTensorOutput;
import io.skylite.ml.common.output.model.ModelTensors;
import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.commons.text.StringSubstitutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MLFlowAgentRunner
implements MLAgentRunner {
    private static final Logger log = LogManager.getLogger(MLFlowAgentRunner.class);
    private ReleasableSkyliteClient client;
    private Settings settings;
    private ClusterService clusterService;
    private NamedXContentRegistry xContentRegistry;
    private Map<String, Tool.Factory<?>> toolFactories;
    private Map<String, Memory.Factory> memoryFactoryMap;

    public MLFlowAgentRunner() {
    }

    public MLFlowAgentRunner(ReleasableSkyliteClient client, Settings settings, ClusterService clusterService, NamedXContentRegistry xContentRegistry, Map<String, Tool.Factory<?>> toolFactories, Map<String, Memory.Factory> memoryFactoryMap) {
        this.client = client;
        this.settings = settings;
        this.clusterService = clusterService;
        this.xContentRegistry = xContentRegistry;
        this.toolFactories = toolFactories;
        this.memoryFactoryMap = memoryFactoryMap;
    }

    public void run(MLAgent mlAgent, Map<String, String> params, ActionListener<Object> listener) {
        List<MLToolSpec> toolSpecs = AgentUtils.getMlToolSpecs(mlAgent, params);
        StepListener firstStepListener = null;
        Tool firstTool = null;
        ArrayList flowAgentOutput = new ArrayList();
        Map<String, String> firstToolExecuteParams = null;
        StepListener previousStepListener = null;
        ConcurrentHashMap additionalInfo = new ConcurrentHashMap();
        if (toolSpecs == null || toolSpecs.isEmpty()) {
            listener.onFailure((Exception)new IllegalArgumentException("no tool configured"));
            return;
        }
        MLMemorySpec memorySpec = mlAgent.getMemory();
        String memoryId = params.get("memory_id");
        String parentInteractionId = params.get("parent_interaction_id");
        for (int i = 0; i <= toolSpecs.size(); ++i) {
            if (i == 0) {
                MLToolSpec toolSpec = toolSpecs.get(i);
                Tool tool = this.createTool(toolSpec, mlAgent.getTenantId());
                previousStepListener = firstStepListener = new StepListener();
                firstTool = tool;
                firstToolExecuteParams = this.getToolExecuteParams(toolSpec, params, mlAgent.getTenantId());
                continue;
            }
            MLToolSpec previousToolSpec = toolSpecs.get(i - 1);
            StepListener nextStepListener = new StepListener();
            int finalI = i;
            previousStepListener.whenComplete(output -> {
                String key = AgentUtils.getToolName(previousToolSpec);
                String outputKey = key + ".output";
                String outputResponse = this.parseResponse(output);
                params.put(outputKey, StringEscapeUtils.escapeJson((String)outputResponse));
                if (previousToolSpec.isIncludeOutputInAgentResponse() || finalI == toolSpecs.size()) {
                    if (output instanceof ModelTensorOutput) {
                        flowAgentOutput.addAll(((ModelTensors)((ModelTensorOutput)output).getMlModelOutputs().get(0)).getMlModelTensors());
                    } else {
                        String result = output instanceof String ? (String)output : AccessController.doPrivileged(() -> Strings.toJson((Object)output));
                        ModelTensor stepOutput = ModelTensor.builder().name(key).result(result).build();
                        flowAgentOutput.add(stepOutput);
                    }
                    additionalInfo.put(outputKey, outputResponse);
                }
                if (finalI == toolSpecs.size()) {
                    if (memoryId == null || parentInteractionId == null || memorySpec == null || memorySpec.getType() == null) {
                        listener.onResponse((Object)flowAgentOutput);
                    } else {
                        ActionListener updateListener = ActionListenerHelper.wrap(updateResponse -> {
                            log.info("Updated additional info for interaction ID: {} in the flow agent.", (Object)updateResponse.getId());
                            listener.onResponse((Object)flowAgentOutput);
                        }, e -> {
                            log.error("Failed to update root interaction", (Throwable)e);
                            listener.onResponse((Object)flowAgentOutput);
                        });
                        this.updateMemoryWithListener(additionalInfo, memorySpec, memoryId, parentInteractionId, updateListener);
                    }
                    return;
                }
                MLToolSpec toolSpec = (MLToolSpec)toolSpecs.get(finalI);
                Tool tool = this.createTool(toolSpec, mlAgent.getTenantId());
                if (finalI < toolSpecs.size()) {
                    tool.run(this.getToolExecuteParams(toolSpec, params, mlAgent.getTenantId()), (ActionListener)nextStepListener);
                }
            }, e -> {
                log.error("Failed to run flow agent", (Throwable)e);
                listener.onFailure(e);
            });
            previousStepListener = nextStepListener;
        }
        if (toolSpecs.size() == 1) {
            firstTool.run(firstToolExecuteParams, listener);
        } else {
            firstTool.run(firstToolExecuteParams, firstStepListener);
        }
    }

    void updateMemory(Map<String, Object> additionalInfo, MLMemorySpec memorySpec, String memoryId, String interactionId) {
        if (memoryId == null || interactionId == null || memorySpec == null || memorySpec.getType() == null) {
            return;
        }
        ConversationIndexMemory.Factory conversationIndexMemoryFactory = (ConversationIndexMemory.Factory)this.memoryFactoryMap.get(memorySpec.getType());
        conversationIndexMemoryFactory.create(memoryId, (ActionListener<ConversationIndexMemory>)ActionListenerHelper.wrap(memory -> this.updateInteraction(additionalInfo, interactionId, (ConversationIndexMemory)memory), e -> log.error("Failed create memory from id: {}", (Object)memoryId)));
    }

    void updateMemoryWithListener(Map<String, Object> additionalInfo, MLMemorySpec memorySpec, String memoryId, String interactionId, ActionListener listener) {
        if (memoryId == null || interactionId == null || memorySpec == null || memorySpec.getType() == null) {
            return;
        }
        ConversationIndexMemory.Factory conversationIndexMemoryFactory = (ConversationIndexMemory.Factory)this.memoryFactoryMap.get(memorySpec.getType());
        conversationIndexMemoryFactory.create(memoryId, (ActionListener<ConversationIndexMemory>)ActionListenerHelper.wrap(memory -> this.updateInteractionWithListener(additionalInfo, interactionId, (ConversationIndexMemory)memory, listener), e -> log.error("Failed create memory from id: {}", (Object)memoryId)));
    }

    void updateInteraction(Map<String, Object> additionalInfo, String interactionId, ConversationIndexMemory memory) {
        memory.getMemoryManager().updateInteraction(interactionId, Map.of("additional_info", additionalInfo), (ActionListener<UpdateResponse>)ActionListenerHelper.wrap(updateResponse -> log.info("Updated additional info for interaction ID: {}", (Object)interactionId), e -> log.error("Failed to update root interaction", (Throwable)e)));
    }

    void updateInteractionWithListener(Map<String, Object> additionalInfo, String interactionId, ConversationIndexMemory memory, ActionListener listener) {
        memory.getMemoryManager().updateInteraction(interactionId, Map.of("additional_info", additionalInfo), (ActionListener<UpdateResponse>)listener);
    }

    String parseResponse(Object output) throws IOException {
        if (output instanceof List && !((List)output).isEmpty() && ((List)output).get(0) instanceof ModelTensors) {
            ModelTensors tensors = (ModelTensors)((List)output).get(0);
            return tensors.toXContent(MediaTypeRegistry.JSON.contentBuilder(), null).toString();
        }
        if (output instanceof ModelTensor) {
            return ((ModelTensor)output).toXContent(MediaTypeRegistry.JSON.contentBuilder(), null).toString();
        }
        if (output instanceof ModelTensorOutput) {
            return ((ModelTensorOutput)output).toXContent(MediaTypeRegistry.JSON.contentBuilder(), null).toString();
        }
        if (output instanceof String) {
            return (String)output;
        }
        return Strings.toJson((Object)output);
    }

    Tool createTool(MLToolSpec toolSpec, String tenantId) {
        HashMap<String, String> toolParams = new HashMap<String, String>();
        if (toolSpec.getParameters() != null) {
            toolParams.putAll(toolSpec.getParameters());
        }
        toolParams.put("tenant_id", tenantId);
        if (!this.toolFactories.containsKey(toolSpec.getType())) {
            throw new IllegalArgumentException("Tool not found: " + toolSpec.getType());
        }
        Tool tool = this.toolFactories.get(toolSpec.getType()).create(toolParams);
        if (toolSpec.getName() != null) {
            tool.setName(toolSpec.getName());
        }
        if (toolSpec.getDescription() != null) {
            tool.setDescription(toolSpec.getDescription());
        }
        return tool;
    }

    Map<String, String> getToolExecuteParams(MLToolSpec toolSpec, Map<String, String> params, String tenantId) {
        HashMap<String, String> executeParams = new HashMap<String, String>();
        if (toolSpec.getParameters() != null) {
            executeParams.putAll(toolSpec.getParameters());
        }
        for (String key : params.keySet()) {
            String toBeReplaced = null;
            if (key.startsWith(toolSpec.getType() + ".")) {
                toBeReplaced = toolSpec.getType() + ".";
            }
            if (toolSpec.getName() != null && key.startsWith(toolSpec.getName() + ".")) {
                toBeReplaced = toolSpec.getName() + ".";
            }
            if (toBeReplaced != null) {
                executeParams.put(key.replace(toBeReplaced, ""), params.get(key));
                continue;
            }
            executeParams.put(key, params.get(key));
        }
        if (toolSpec.getConfigMap() != null && !toolSpec.getConfigMap().isEmpty()) {
            executeParams.putAll(toolSpec.getConfigMap());
        }
        executeParams.put("tenant_id", tenantId);
        if (executeParams.containsKey("input")) {
            String input = (String)executeParams.get("input");
            StringSubstitutor substitutor = new StringSubstitutor(executeParams, "${parameters.", "}");
            input = substitutor.replace(input);
            executeParams.put("input", input);
        }
        return executeParams;
    }

    public ReleasableSkyliteClient getClient() {
        return this.client;
    }

    public void setClient(ReleasableSkyliteClient client) {
        this.client = client;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public ClusterService getClusterService() {
        return this.clusterService;
    }

    public void setClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    public NamedXContentRegistry getxContentRegistry() {
        return this.xContentRegistry;
    }

    public void setxContentRegistry(NamedXContentRegistry xContentRegistry) {
        this.xContentRegistry = xContentRegistry;
    }

    public Map<String, Tool.Factory<?>> getToolFactories() {
        return this.toolFactories;
    }

    public void setToolFactories(Map<String, Tool.Factory<?>> toolFactories) {
        this.toolFactories = toolFactories;
    }

    public Map<String, Memory.Factory> getMemoryFactoryMap() {
        return this.memoryFactoryMap;
    }

    public void setMemoryFactoryMap(Map<String, Memory.Factory> memoryFactoryMap) {
        this.memoryFactoryMap = memoryFactoryMap;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MLFlowAgentRunner that = (MLFlowAgentRunner)o;
        return Objects.equals(this.client, that.client) && Objects.equals(this.settings, that.settings) && Objects.equals(this.clusterService, that.clusterService) && Objects.equals(this.xContentRegistry, that.xContentRegistry) && Objects.equals(this.toolFactories, that.toolFactories) && Objects.equals(this.memoryFactoryMap, that.memoryFactoryMap);
    }

    public int hashCode() {
        return Objects.hash(this.client, this.settings, this.clusterService, this.xContentRegistry, this.toolFactories, this.memoryFactoryMap);
    }

    public String toString() {
        return "MLFlowAgentRunner{client=" + String.valueOf(this.client) + ", settings=" + String.valueOf(this.settings) + ", clusterService=" + String.valueOf(this.clusterService) + ", xContentRegistry=" + String.valueOf(this.xContentRegistry) + ", toolFactories=" + String.valueOf(this.toolFactories) + ", memoryFactoryMap=" + String.valueOf(this.memoryFactoryMap) + "}";
    }
}

