/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.engine.algorithms.clustering;

import io.lucenia.ml.common.engine.algorithms.clustering.Weighted;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class SampleSummary {
    public static double DEFAULT_PERCENTILE = 0.9;
    public float[][] summaryPoints;
    public float[] relativeWeight;
    public double weightOfSamples;
    public float[] mean;
    public float[] median;
    public float[] deviation;
    public float[] upper;
    public float[] lower;

    public SampleSummary(double weightOfSamples, float[][] typicalPoints, float[] relativeLikelihood, float[] median, float[] mean, float[] deviation, float[] upper, float[] lower) {
        if (!(typicalPoints.length == relativeLikelihood.length)) {
            throw new IllegalArgumentException("incorrect lengths of fields");
        }
        this.weightOfSamples = weightOfSamples;
        this.summaryPoints = typicalPoints;
        this.relativeWeight = relativeLikelihood;
        this.mean = mean;
        this.median = median;
        this.deviation = deviation;
        this.upper = upper;
        this.lower = lower;
    }

    public SampleSummary(int dimensions) {
        this.weightOfSamples = 0.0;
        this.summaryPoints = new float[1][];
        this.summaryPoints[0] = new float[dimensions];
        this.relativeWeight = new float[]{0.0f};
        this.median = new float[dimensions];
        this.mean = new float[dimensions];
        this.deviation = new float[dimensions];
        this.upper = new float[dimensions];
        this.lower = new float[dimensions];
    }

    public SampleSummary(float[] point) {
        this(SampleSummary.toDoubleArray(point), 1.0f);
    }

    public SampleSummary(double[] point, float weight) {
        this(point.length);
        this.weightOfSamples = weight;
        this.summaryPoints[0] = SampleSummary.toFloatArray(point);
        this.relativeWeight[0] = weight;
        System.arraycopy(this.summaryPoints[0], 0, this.median, 0, point.length);
        System.arraycopy(this.summaryPoints[0], 0, this.mean, 0, point.length);
        System.arraycopy(this.summaryPoints[0], 0, this.upper, 0, point.length);
        System.arraycopy(this.summaryPoints[0], 0, this.lower, 0, point.length);
    }

    public SampleSummary(float[][] summaryPoints, float[] relativeWeight) {
        this.addTypical(summaryPoints, relativeWeight);
    }

    void addTypical(float[][] summaryPoints, float[] relativeWeight) {
        SampleSummary.checkArgument(summaryPoints.length == relativeWeight.length, "incorrect lengths of fields");
        if (summaryPoints.length > 0) {
            int dimension = summaryPoints[0].length;
            this.summaryPoints = new float[summaryPoints.length][];
            for (int i = 0; i < summaryPoints.length; ++i) {
                SampleSummary.checkArgument(dimension == summaryPoints[i].length, " incorrect length points");
                this.summaryPoints[i] = Arrays.copyOf(summaryPoints[i], dimension);
            }
            this.relativeWeight = Arrays.copyOf(relativeWeight, relativeWeight.length);
        }
    }

    public SampleSummary(List<Weighted<float[]>> points, float[][] summaryPoints, float[] relativeWeight, double percentile) {
        this(points, percentile);
        this.addTypical(summaryPoints, relativeWeight);
    }

    public SampleSummary(List<Weighted<float[]>> points, float[][] summaryPoints, float[] relativeWeight) {
        this(points, summaryPoints, relativeWeight, DEFAULT_PERCENTILE);
    }

    public SampleSummary(List<Weighted<float[]>> points) {
        this(points, DEFAULT_PERCENTILE);
    }

    public SampleSummary(List<Weighted<float[]>> points, double percentile) {
        int i;
        SampleSummary.checkArgument(points.size() > 0, "point list cannot be empty");
        SampleSummary.checkArgument(percentile > 0.5 && percentile < 1.0, "invalid ranges of the bound");
        int dimension = ((float[])points.get((int)0).index).length;
        double[] coordinateSum = new double[dimension];
        double[] coordinateSumSquare = new double[dimension];
        double totalWeight = 0.0;
        for (Weighted<float[]> e2 : points) {
            SampleSummary.checkArgument(((float[])e2.index).length == dimension, "points have to be of same length");
            float weight = e2.weight;
            SampleSummary.checkArgument(weight >= 0.0f, "weights have to be non-negative");
            totalWeight += (double)weight;
            for (int i2 = 0; i2 < dimension; ++i2) {
                SampleSummary.checkArgument(!Float.isNaN(weight) && Float.isFinite(weight), " weights must be finite, non-NaN values ");
                SampleSummary.checkArgument(!Float.isNaN(((float[])e2.index)[i2]) && Float.isFinite(((float[])e2.index)[i2]), " improper input, in coordinate " + i2 + ", must be finite, non-NaN values");
                int n = i2;
                coordinateSum[n] = coordinateSum[n] + (double)(((float[])e2.index)[i2] * weight);
                int n2 = i2;
                coordinateSumSquare[n2] = coordinateSumSquare[n2] + (double)(((float[])e2.index)[i2] * ((float[])e2.index)[i2] * weight);
            }
        }
        SampleSummary.checkArgument(totalWeight > 0.0, " weights cannot all be 0");
        this.weightOfSamples = totalWeight;
        this.mean = new float[dimension];
        this.deviation = new float[dimension];
        this.median = new float[dimension];
        this.upper = new float[dimension];
        this.lower = new float[dimension];
        for (i = 0; i < dimension; ++i) {
            this.mean[i] = (float)(coordinateSum[i] / totalWeight);
            this.deviation[i] = (float)Math.sqrt(Math.max(0.0, coordinateSumSquare[i] / totalWeight - (double)(this.mean[i] * this.mean[i])));
        }
        for (i = 0; i < dimension; ++i) {
            int index = i;
            ArrayList list = points.stream().map(e -> new Weighted<Float>(Float.valueOf(((float[])e.index)[index]), e.weight)).collect(Collectors.toCollection(ArrayList::new));
            list.sort((o1, o2) -> Float.compare(((Float)o1.index).floatValue(), ((Float)o2.index).floatValue()));
            this.lower[i] = ((Float)Weighted.prefixPick(list, (double)(totalWeight * (1.0 - percentile))).index).floatValue();
            this.median[i] = ((Float)Weighted.prefixPick(list, (double)(totalWeight / 2.0)).index).floatValue();
            this.upper[i] = ((Float)Weighted.prefixPick(list, (double)(totalWeight * percentile)).index).floatValue();
        }
    }

    public static void checkArgument(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }

    public static double[] toDoubleArray(float[] array) {
        SampleSummary.checkNotNull(array, "array must not be null");
        double[] result = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static float[] toFloatArray(double[] array) {
        SampleSummary.checkNotNull(array, "array must not be null");
        float[] result = new float[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i] == 0.0 ? 0.0f : (float)array[i];
        }
        return result;
    }

    public static <T> T checkNotNull(T object, String message) {
        Objects.requireNonNull(object, message);
        return object;
    }
}

