/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.engine.algorithms.clustering;

import io.lucenia.ml.common.engine.algorithms.clustering.SampleSummary;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;

public class SerializableSummary
implements Serializable {
    private float[][] summaryPoints;
    private float[] mean;
    private float[] median;
    private float[] deviation;
    private float[] lower;
    private float[] upper;
    private float[] relativeWeight;
    private double weightOfSamples;

    public SerializableSummary() {
    }

    public SerializableSummary(SampleSummary s) {
        this.summaryPoints = s.summaryPoints;
        this.mean = s.mean;
        this.deviation = s.deviation;
        this.lower = s.lower;
        this.upper = s.upper;
        this.relativeWeight = s.relativeWeight;
        this.weightOfSamples = s.weightOfSamples;
        this.median = s.median;
    }

    public SampleSummary getSummary() {
        SampleSummary summary = new SampleSummary(0);
        summary.summaryPoints = this.summaryPoints;
        summary.deviation = this.deviation;
        summary.lower = this.lower;
        summary.upper = this.upper;
        summary.mean = this.mean;
        summary.median = this.median;
        summary.relativeWeight = this.relativeWeight;
        summary.weightOfSamples = this.weightOfSamples;
        return summary;
    }

    public float[][] getSummaryPoints() {
        return this.summaryPoints;
    }

    public void setSummaryPoints(float[][] summaryPoints) {
        this.summaryPoints = summaryPoints;
    }

    public float[] getMean() {
        return this.mean;
    }

    public void setMean(float[] mean) {
        this.mean = mean;
    }

    public float[] getMedian() {
        return this.median;
    }

    public void setMedian(float[] median) {
        this.median = median;
    }

    public float[] getDeviation() {
        return this.deviation;
    }

    public void setDeviation(float[] deviation) {
        this.deviation = deviation;
    }

    public float[] getLower() {
        return this.lower;
    }

    public void setLower(float[] lower) {
        this.lower = lower;
    }

    public float[] getUpper() {
        return this.upper;
    }

    public void setUpper(float[] upper) {
        this.upper = upper;
    }

    public float[] getRelativeWeight() {
        return this.relativeWeight;
    }

    public void setRelativeWeight(float[] relativeWeight) {
        this.relativeWeight = relativeWeight;
    }

    public double getWeightOfSamples() {
        return this.weightOfSamples;
    }

    public void setWeightOfSamples(double weightOfSamples) {
        this.weightOfSamples = weightOfSamples;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SerializableSummary that = (SerializableSummary)o;
        return Double.compare(this.weightOfSamples, that.weightOfSamples) == 0 && Objects.deepEquals(this.summaryPoints, that.summaryPoints) && Objects.deepEquals(this.mean, that.mean) && Objects.deepEquals(this.median, that.median) && Objects.deepEquals(this.deviation, that.deviation) && Objects.deepEquals(this.lower, that.lower) && Objects.deepEquals(this.upper, that.upper) && Objects.deepEquals(this.relativeWeight, that.relativeWeight);
    }

    public int hashCode() {
        return Objects.hash(Arrays.deepHashCode((Object[])this.summaryPoints), Arrays.hashCode(this.mean), Arrays.hashCode(this.median), Arrays.hashCode(this.deviation), Arrays.hashCode(this.lower), Arrays.hashCode(this.upper), Arrays.hashCode(this.relativeWeight), this.weightOfSamples);
    }

    public String toString() {
        return "SerializableSummary{summaryPoints=" + Arrays.toString((Object[])this.summaryPoints) + ", mean=" + Arrays.toString(this.mean) + ", median=" + Arrays.toString(this.median) + ", deviation=" + Arrays.toString(this.deviation) + ", lower=" + Arrays.toString(this.lower) + ", upper=" + Arrays.toString(this.upper) + ", relativeWeight=" + Arrays.toString(this.relativeWeight) + ", weightOfSamples=" + this.weightOfSamples + "}";
    }
}

