/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.engine.algorithms.clustering;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class Weighted<Q> {
    public Q index;
    public float weight;

    public Weighted(Q object, float weight) {
        this.index = object;
        this.weight = weight;
    }

    public static <Q> List<Weighted<Q>> createSample(List<Weighted<Q>> input, long seed, int lengthBound, double forceSampleFraction, double scale) {
        double totalWeight;
        if (input.size() < lengthBound) {
            return input;
        }
        ArrayList samples = new ArrayList();
        Random rng = new Random(seed);
        double remainder = totalWeight = input.stream().map(x -> x.weight).reduce(Double::sum).get().doubleValue();
        if (forceSampleFraction > 0.0) {
            remainder = input.stream().map(e -> {
                if ((double)e.weight > totalWeight * forceSampleFraction) {
                    samples.add(new Weighted(e.index, e.weight));
                    return 0.0;
                }
                return e.weight;
            }).reduce(Double::sum).get();
        }
        float factor = (float)((double)lengthBound * 1.0 / (double)input.size());
        float newScale = (float)(scale * (remainder / totalWeight) / (double)factor);
        input.stream().forEach(e -> {
            if ((double)e.weight <= totalWeight * forceSampleFraction && rng.nextDouble() < (double)factor) {
                samples.add(new Weighted(e.index, e.weight * newScale));
            }
        });
        return samples;
    }

    public static <Q> Weighted<Q> prefixPick(List<Weighted<Q>> points, double wt) {
        if (points.isEmpty()) {
            throw new IllegalArgumentException("cannot pick from an empty list");
        }
        double running = wt;
        Weighted<Q> saved = points.get(0);
        for (Weighted<Q> point : points) {
            if (running - (double)point.weight <= 0.0) {
                return point;
            }
            running -= (double)point.weight;
            saved = point;
        }
        return saved;
    }
}

