/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.engine.algorithms.question_answering;

import ai.djl.inference.Predictor;
import ai.djl.modality.Input;
import ai.djl.modality.Output;
import ai.djl.translate.TranslateException;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorFactory;
import io.lucenia.ml.common.engine.algorithms.question_answering.QuestionAnsweringTranslator;
import io.skylite.ml.common.FunctionName;
import io.skylite.ml.common.algorithms.DLModel;
import io.skylite.ml.common.annotation.Function;
import io.skylite.ml.common.dataset.MLInputDataset;
import io.skylite.ml.common.dataset.QuestionAnsweringInputDataSet;
import io.skylite.ml.common.input.MLInput;
import io.skylite.ml.common.model.MLModelConfig;
import io.skylite.ml.common.output.model.ModelTensorOutput;
import io.skylite.ml.common.output.model.ModelTensors;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Function(value=FunctionName.QUESTION_ANSWERING)
public class QuestionAnsweringModel
extends DLModel {
    private static final Logger log = LogManager.getLogger(QuestionAnsweringModel.class);

    public void warmUp(Predictor predictor, String modelId, MLModelConfig modelConfig) throws TranslateException {
        String question = "How is the weather?";
        String context = "The weather is nice, it is beautiful day.";
        Input input = new Input();
        input.add(question);
        input.add(context);
        predictor.predict((Object)input);
    }

    public ModelTensorOutput predict(String modelId, MLInput mlInput) throws TranslateException {
        MLInputDataset inputDataSet = mlInput.getInputDataset();
        ArrayList<ModelTensors> tensorOutputs = new ArrayList<ModelTensors>();
        QuestionAnsweringInputDataSet qaInputDataSet = (QuestionAnsweringInputDataSet)inputDataSet;
        String question = qaInputDataSet.getQuestion();
        String context = qaInputDataSet.getContext();
        Input input = new Input();
        input.add(question);
        input.add(context);
        Output output = (Output)this.getPredictor().predict((Object)input);
        tensorOutputs.add(this.parseModelTensorOutput(output, null));
        return new ModelTensorOutput(tensorOutputs);
    }

    public Translator<Input, Output> getTranslator(String engine, MLModelConfig modelConfig) throws IllegalArgumentException {
        return new QuestionAnsweringTranslator();
    }

    public TranslatorFactory getTranslatorFactory(String engine, MLModelConfig modelConfig) {
        return null;
    }
}

