/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.engine.algorithms.text_embedding;

import ai.djl.huggingface.tokenizers.Encoding;
import ai.djl.huggingface.tokenizers.HuggingFaceTokenizer;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.types.DataType;
import ai.djl.translate.ArgumentsUtil;
import ai.djl.translate.Batchifier;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorContext;
import java.io.IOException;
import java.util.Map;

public class HuggingfaceTextEmbeddingTranslator
implements Translator<String, float[]> {
    private static final int[] AXIS = new int[]{0};
    private HuggingFaceTokenizer tokenizer;
    private Batchifier batchifier;
    private boolean normalize;
    private String pooling;
    private boolean inputTokenTypeIds;

    HuggingfaceTextEmbeddingTranslator(HuggingFaceTokenizer tokenizer, Batchifier batchifier, String pooling, boolean normalize, boolean inputTokenTypeIds) {
        this.tokenizer = tokenizer;
        this.batchifier = batchifier;
        this.pooling = pooling;
        this.normalize = normalize;
        this.inputTokenTypeIds = inputTokenTypeIds;
    }

    public Batchifier getBatchifier() {
        return this.batchifier;
    }

    public NDList processInput(TranslatorContext ctx, String input) {
        NDManager manager = ctx.getNDManager();
        Encoding encoding = this.tokenizer.encode(input);
        ctx.setAttachment("encoding", (Object)encoding);
        long[] indices = encoding.getIds();
        long[] attentionMask = encoding.getAttentionMask();
        NDList ndList = new NDList(2);
        ndList.add((Object)manager.create(indices));
        ndList.add((Object)manager.create(attentionMask));
        if (this.inputTokenTypeIds) {
            long[] tokenTypeIds = encoding.getTypeIds();
            ndList.add((Object)manager.create(tokenTypeIds));
        }
        return ndList;
    }

    public float[] processOutput(TranslatorContext ctx, NDList list) {
        NDArray embeddings = list.get("last_hidden_state");
        if (embeddings == null) {
            embeddings = (NDArray)list.get(0);
        }
        Encoding encoding = (Encoding)ctx.getAttachment("encoding");
        long[] attentionMask = encoding.getAttentionMask();
        NDManager manager = ctx.getNDManager();
        NDArray inputAttentionMask = manager.create(attentionMask).toType(DataType.FLOAT32, true);
        switch (this.pooling) {
            case "mean": {
                embeddings = this.meanPool(embeddings, inputAttentionMask, false);
                break;
            }
            case "mean_sqrt_len": {
                embeddings = this.meanPool(embeddings, inputAttentionMask, true);
                break;
            }
            case "max": {
                embeddings = this.maxPool(embeddings, inputAttentionMask);
                break;
            }
            case "weightedmean": {
                embeddings = this.weightedMeanPool(embeddings, inputAttentionMask);
                break;
            }
            case "cls": {
                embeddings = embeddings.get(new long[]{0L});
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected pooling model: " + this.pooling));
            }
        }
        if (this.normalize) {
            embeddings = embeddings.normalize(2.0, 0L);
        }
        return embeddings.toFloatArray();
    }

    private NDArray meanPool(NDArray embeddings, NDArray inputAttentionMask, boolean sqrt) {
        long[] shape = embeddings.getShape().getShape();
        inputAttentionMask = inputAttentionMask.expandDims(-1).broadcast(shape);
        NDArray inputAttentionMaskSum = inputAttentionMask.sum(AXIS);
        NDArray clamp = inputAttentionMaskSum.clip((Number)1.0E-9, (Number)1.0E12);
        NDArray prod = embeddings.mul(inputAttentionMask);
        NDArray sum = prod.sum(AXIS);
        if (sqrt) {
            return sum.div(clamp.sqrt());
        }
        return sum.div(clamp);
    }

    private NDArray maxPool(NDArray embeddings, NDArray inputAttentionMask) {
        long[] shape = embeddings.getShape().getShape();
        inputAttentionMask = inputAttentionMask.expandDims(-1).broadcast(shape);
        inputAttentionMask = inputAttentionMask.eq((Number)0);
        embeddings = embeddings.duplicate();
        embeddings.set(inputAttentionMask, (Number)-1.0E9);
        return embeddings.max(AXIS, true);
    }

    private NDArray weightedMeanPool(NDArray embeddings, NDArray inputAttentionMask) {
        long[] shape = embeddings.getShape().getShape();
        NDArray weight = embeddings.getManager().arange(1.0f, (float)(shape[0] + 1L));
        weight = weight.expandDims(-1).broadcast(shape);
        inputAttentionMask = inputAttentionMask.expandDims(-1).broadcast(shape).mul(weight);
        NDArray maskSum = inputAttentionMask.sum(AXIS);
        NDArray embeddingSum = embeddings.mul(inputAttentionMask).sum(AXIS);
        return embeddingSum.div(maskSum);
    }

    public static Builder builder(HuggingFaceTokenizer tokenizer) {
        return new Builder(tokenizer);
    }

    public static Builder builder(HuggingFaceTokenizer tokenizer, Map<String, ?> arguments) {
        Builder builder = HuggingfaceTextEmbeddingTranslator.builder(tokenizer);
        builder.configure(arguments);
        return builder;
    }

    public static final class Builder {
        private HuggingFaceTokenizer tokenizer;
        private Batchifier batchifier = Batchifier.STACK;
        private boolean normalize = false;
        private boolean inputTokenTypeIds = false;
        private String pooling = "mean";

        Builder(HuggingFaceTokenizer tokenizer) {
            this.tokenizer = tokenizer;
        }

        public Builder optBatchifier(Batchifier batchifier) {
            this.batchifier = batchifier;
            return this;
        }

        public Builder optNormalize(boolean normalize) {
            this.normalize = normalize;
            return this;
        }

        public Builder optPoolingMode(String poolingMode) {
            if (!("mean".equals(poolingMode) || "max".equals(poolingMode) || "cls".equals(poolingMode) || "mean_sqrt_len".equals(poolingMode) || "weightedmean".equals(poolingMode))) {
                throw new IllegalArgumentException("Invalid pooling model, must be one of [mean_tokens, max_tokens, cls_token, mean_sqrt_len_tokens, weightedmean_tokens].");
            }
            this.pooling = poolingMode;
            return this;
        }

        public Builder optInputTokenTypeIds(boolean inputTokenTypeIds) {
            this.inputTokenTypeIds = inputTokenTypeIds;
            return this;
        }

        public void configure(Map<String, ?> arguments) {
            String batchifierStr = ArgumentsUtil.stringValue(arguments, (String)"batchifier", (String)"stack");
            this.optBatchifier(Batchifier.fromString((String)batchifierStr));
            this.optNormalize(ArgumentsUtil.booleanValue(arguments, (String)"normalize", (boolean)false));
            this.optInputTokenTypeIds(ArgumentsUtil.booleanValue(arguments, (String)"inputTokenTypeIds", (boolean)false));
            this.optPoolingMode(ArgumentsUtil.stringValue(arguments, (String)"pooling", (String)"mean"));
        }

        public HuggingfaceTextEmbeddingTranslator build() throws IOException {
            return new HuggingfaceTextEmbeddingTranslator(this.tokenizer, this.batchifier, this.pooling, this.normalize, this.inputTokenTypeIds);
        }
    }
}

