/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.engine.ingest;

import com.fasterxml.jackson.databind.JsonNode;
import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.bulk.BulkRequest;
import io.skylite.core.action.bulk.BulkResponse;
import io.skylite.core.action.index.IndexRequest;
import io.skylite.core.action.update.UpdateRequest;
import io.skylite.core.client.Client;
import io.skylite.core.common.Strings;
import io.skylite.core.rest.RestStatus;
import io.skylite.ml.common.engine.ingest.Ingestable;
import io.skylite.ml.common.transport.batch.MLBatchIngestionInput;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AbstractIngestion
implements Ingestable {
    private static final Logger log = LogManager.getLogger(AbstractIngestion.class);
    private final Client client;

    public AbstractIngestion(Client client) {
        this.client = client;
    }

    protected ActionListener<BulkResponse> getBulkResponseListener(AtomicInteger successfulBatches, AtomicInteger failedBatches, CompletableFuture<Void> future) {
        return ActionListenerHelper.wrap(bulkResponse -> {
            if (bulkResponse.hasFailures()) {
                failedBatches.incrementAndGet();
                future.completeExceptionally(new RuntimeException(bulkResponse.buildFailureMessage()));
                return;
            }
            log.debug("Batch Ingestion successfully");
            successfulBatches.incrementAndGet();
            future.complete(null);
        }, e -> {
            log.error("Failed to Batch Ingestion", (Throwable)e);
            failedBatches.incrementAndGet();
            future.completeExceptionally((Throwable)e);
        });
    }

    protected double calculateSuccessRate(List<Double> successRates) {
        return (Double)successRates.stream().min(Double::compare).orElseThrow(() -> new SkyliteStatusException("Failed to batch ingest data as not success rate is returned", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
    }

    protected Map<String, Object> filterFieldMappingSoleSource(MLBatchIngestionInput mlBatchIngestionInput) {
        Map fieldMap = mlBatchIngestionInput.getFieldMapping();
        String prefix = "source[0]";
        Map<String, Object> filteredFieldMap = fieldMap.entrySet().stream().filter(entry -> {
            Object value = entry.getValue();
            if (value instanceof String) {
                String jsonPath = (String)value;
                return jsonPath.contains(prefix) || !jsonPath.startsWith("source");
            }
            if (value instanceof List) {
                return ((List)value).stream().anyMatch(val -> val.contains(prefix) || !val.startsWith("source"));
            }
            return false;
        }).collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            Object value = entry.getValue();
            if (value instanceof String) {
                return Strings.getJsonPath((String)((String)value));
            }
            if (value instanceof List) {
                return ((List)value).stream().filter(val -> val.contains(prefix) || !val.startsWith("source")).map(Strings::getJsonPath).collect(Collectors.toList());
            }
            return null;
        }));
        String[] ingestFields = mlBatchIngestionInput.getIngestFields();
        if (ingestFields != null) {
            Arrays.stream(ingestFields).filter(Objects::nonNull).filter(val -> val.contains(prefix) || !val.startsWith("source")).map(Strings::getJsonPath).forEach(jsonPath -> filteredFieldMap.put(Strings.obtainFieldNameFromJsonPath((String)jsonPath), jsonPath));
        }
        return filteredFieldMap;
    }

    protected Map<String, Object> filterFieldMapping(MLBatchIngestionInput mlBatchIngestionInput, int indexInFieldMap) {
        Map fieldMap = mlBatchIngestionInput.getFieldMapping();
        String prefix = "source[" + indexInFieldMap + "]";
        Map<String, Object> filteredFieldMap = fieldMap.entrySet().stream().filter(entry -> {
            Object value = entry.getValue();
            if (value instanceof String) {
                return ((String)value).contains(prefix);
            }
            if (value instanceof List) {
                return ((List)value).stream().anyMatch(val -> val.contains(prefix));
            }
            return false;
        }).collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            Object value = entry.getValue();
            if (value instanceof String) {
                return Strings.getJsonPath((String)((String)value));
            }
            if (value instanceof List) {
                return ((List)value).stream().filter(val -> val.contains(prefix)).map(Strings::getJsonPath).collect(Collectors.toList());
            }
            return null;
        }));
        String[] ingestFields = mlBatchIngestionInput.getIngestFields();
        if (ingestFields != null) {
            Arrays.stream(ingestFields).filter(Objects::nonNull).filter(val -> val.contains(prefix)).map(Strings::getJsonPath).forEach(jsonPath -> filteredFieldMap.put(Strings.obtainFieldNameFromJsonPath((String)jsonPath), jsonPath));
        }
        return filteredFieldMap;
    }

    protected Map<String, Object> processFieldMapping(String jsonStr, Map<String, Object> fieldMapping) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (fieldMapping == null || fieldMapping.isEmpty()) {
            return resultMap;
        }
        try {
            JsonNode root = Strings.OBJECT_MAPPER.readTree(jsonStr);
            for (Map.Entry<String, Object> entry : fieldMapping.entrySet()) {
                Object pathObj = entry.getValue();
                if (pathObj instanceof String) {
                    String path = (String)pathObj;
                    Object extracted = Strings.extractFromJsonPath((JsonNode)root, (String)path);
                    resultMap.put(entry.getKey(), extracted);
                    continue;
                }
                if (!(pathObj instanceof List)) continue;
                List pathList = (List)pathObj;
                for (Object pathVal : pathList) {
                    if (!(pathVal instanceof String)) continue;
                    String path = (String)pathVal;
                    Object extracted = Strings.extractFromJsonPath((JsonNode)root, (String)path);
                    resultMap.put(entry.getKey(), extracted);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse input JSON", e);
        }
        return resultMap;
    }

    protected void batchIngest(List<String> sourceLines, MLBatchIngestionInput mlBatchIngestionInput, ActionListener<BulkResponse> bulkResponseListener, int sourceIndex, boolean isSoleSource) {
        BulkRequest bulkRequest = new BulkRequest();
        sourceLines.stream().forEach(jsonStr -> {
            Map<String, Object> filteredMapping = isSoleSource ? this.filterFieldMappingSoleSource(mlBatchIngestionInput) : this.filterFieldMapping(mlBatchIngestionInput, sourceIndex);
            Map<String, Object> jsonMap = this.processFieldMapping((String)jsonStr, filteredMapping);
            if (jsonMap.isEmpty()) {
                return;
            }
            if (isSoleSource && !jsonMap.containsKey("_id")) {
                IndexRequest indexRequest = new IndexRequest(mlBatchIngestionInput.getIndexName());
                indexRequest.source(jsonMap);
                bulkRequest.add(indexRequest);
            } else {
                if (!jsonMap.containsKey("_id")) {
                    throw new IllegalArgumentException("The id filed must be provided to match documents for multiple sources");
                }
                String id = String.valueOf(jsonMap.remove("_id"));
                UpdateRequest updateRequest = new UpdateRequest(mlBatchIngestionInput.getIndexName(), id).doc(jsonMap).upsert(jsonMap);
                bulkRequest.add(updateRequest);
            }
        });
        if (bulkRequest.numberOfActions() == 0) {
            bulkResponseListener.onFailure((Exception)new IllegalArgumentException("the bulk ingestion is empty: please check your field mapping to match your sources"));
            return;
        }
        this.client.bulk(bulkRequest, bulkResponseListener);
    }

    private void populateJsonMap(Map<String, Object> jsonMap, List<String> fieldNames, List<?> modelData) {
        if (modelData != null) {
            if (modelData.size() != fieldNames.size()) {
                throw new IllegalArgumentException("The fieldMapping and source data do not match");
            }
            for (int index = 0; index < modelData.size(); ++index) {
                jsonMap.put(fieldNames.get(index), modelData.get(index));
            }
        }
    }
}

