/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.engine.memory;

import io.lucenia.ml.common.action.memory.conversation.CreateConversationResponse;
import io.lucenia.ml.common.action.memory.conversation.CreateInteractionResponse;
import io.lucenia.ml.common.engine.memory.MLMemoryManager;
import io.lucenia.ml.common.engine.systemindices.MLIndicesHandler;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.WriteRequest;
import io.skylite.core.action.index.IndexRequest;
import io.skylite.core.action.update.UpdateResponse;
import io.skylite.core.client.Client;
import io.skylite.core.client.ReleasableSkyliteClient;
import io.skylite.core.common.Strings;
import io.skylite.core.index.query.BoolQueryBuilder;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.index.query.TermQueryBuilder;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.core.search.sort.SortOrder;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.ml.common.conversation.Interaction;
import io.skylite.ml.common.engine.memory.ConversationIndexMessage;
import io.skylite.ml.common.engine.memory.Memory;
import io.skylite.ml.common.engine.memory.Message;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConversationIndexMemory
implements Memory {
    private static final Logger log = LogManager.getLogger(ConversationIndexMemory.class);
    public static final String TYPE = "conversation_index";
    public static final String CONVERSATION_ID = "conversation_id";
    public static final String FINAL_ANSWER = "final_answer";
    public static final String CREATED_TIME = "created_time";
    public static final String MEMORY_NAME = "memory_name";
    public static final String MEMORY_ID = "memory_id";
    public static final String APP_TYPE = "app_type";
    public static int LAST_N_INTERACTIONS = 10;
    protected String memoryMetaIndexName;
    protected String memoryMessageIndexName;
    protected String conversationId;
    protected boolean retrieveFinalAnswer = true;
    protected final ReleasableSkyliteClient client;
    private final MLIndicesHandler mlIndicesHandler;
    private MLMemoryManager memoryManager;

    public ConversationIndexMemory(Client client, MLIndicesHandler mlIndicesHandler, String memoryMetaIndexName, String memoryMessageIndexName, String conversationId, MLMemoryManager memoryManager) {
        this.client = client;
        this.mlIndicesHandler = mlIndicesHandler;
        this.memoryMetaIndexName = memoryMetaIndexName;
        this.memoryMessageIndexName = memoryMessageIndexName;
        this.conversationId = conversationId;
        this.memoryManager = memoryManager;
    }

    public static int getLastNInteractions() {
        return LAST_N_INTERACTIONS;
    }

    public String getMemoryMetaIndexName() {
        return this.memoryMetaIndexName;
    }

    public String getMemoryMessageIndexName() {
        return this.memoryMessageIndexName;
    }

    public String getConversationId() {
        return this.conversationId;
    }

    public boolean isRetrieveFinalAnswer() {
        return this.retrieveFinalAnswer;
    }

    public ReleasableSkyliteClient getClient() {
        return this.client;
    }

    public MLIndicesHandler getMlIndicesHandler() {
        return this.mlIndicesHandler;
    }

    public MLMemoryManager getMemoryManager() {
        return this.memoryManager;
    }

    public String getType() {
        return TYPE;
    }

    public void save(String id, Message message) {
        this.save(id, message, ActionListenerHelper.wrap(r -> log.info("saved message into {} memory, session id: {}", (Object)TYPE, (Object)id), e -> log.error("Failed to save message to memory", (Throwable)e)));
    }

    public void save(String id, Message message, ActionListener listener) {
        this.mlIndicesHandler.initMemoryMessageIndex((ActionListener<Boolean>)ActionListenerHelper.wrap(created -> {
            if (created.booleanValue()) {
                IndexRequest indexRequest = (IndexRequest)new IndexRequest(this.memoryMessageIndexName).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                ConversationIndexMessage conversationIndexMessage = (ConversationIndexMessage)message;
                XContentBuilder builder = MediaTypeRegistry.JSON.contentBuilder();
                conversationIndexMessage.toXContent(builder, ToXContent.EMPTY_PARAMS);
                indexRequest.source(builder);
                this.client.index(indexRequest, listener);
            } else {
                listener.onFailure((Exception)new RuntimeException("Failed to create memory message index"));
            }
        }, e -> listener.onFailure((Exception)new RuntimeException("Failed to create memory message index", (Throwable)e))));
    }

    public void save(Message message, String parentId, Integer traceNum, String action) {
        this.save(message, parentId, traceNum, action, ActionListenerHelper.wrap(r -> log.info("saved message into memory {}, parent id: {}, trace number: {}, interaction id: {}", (Object)this.conversationId, (Object)parentId, (Object)traceNum, (Object)r.getId()), e -> log.error("Failed to save interaction", (Throwable)e)));
    }

    public void save(Message message, String parentId, Integer traceNum, String action, ActionListener listener) {
        ConversationIndexMessage msg = (ConversationIndexMessage)message;
        this.memoryManager.createInteraction(this.conversationId, msg.getQuestion(), null, msg.getResponse(), action, null, parentId, traceNum, (ActionListener<CreateInteractionResponse>)listener);
    }

    public void getMessages(String id, ActionListener listener) {
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.indices(new String[]{this.memoryMessageIndexName});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.size(10000);
        TermQueryBuilder sessionIdQueryBuilder = new TermQueryBuilder(CONVERSATION_ID, id);
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
        boolQueryBuilder.must((QueryBuilder)sessionIdQueryBuilder);
        if (this.retrieveFinalAnswer) {
            TermQueryBuilder finalAnswerQueryBuilder = new TermQueryBuilder(FINAL_ANSWER, true);
            boolQueryBuilder.must((QueryBuilder)finalAnswerQueryBuilder);
        }
        sourceBuilder.query((QueryBuilder)boolQueryBuilder);
        sourceBuilder.sort(CREATED_TIME, SortOrder.ASC);
        searchRequest.source(sourceBuilder);
        this.client.search(searchRequest, listener);
    }

    public void getMessages(ActionListener listener) {
        this.memoryManager.getFinalInteractions(this.conversationId, LAST_N_INTERACTIONS, (ActionListener<List<Interaction>>)listener);
    }

    public void getMessages(ActionListener listener, int size) {
        this.memoryManager.getFinalInteractions(this.conversationId, size, (ActionListener<List<Interaction>>)listener);
    }

    public void clear() {
        throw new RuntimeException("clear method is not supported in ConversationIndexMemory");
    }

    public void remove(String id) {
        throw new RuntimeException("remove method is not supported in ConversationIndexMemory");
    }

    public void update(String messageId, Map<String, Object> updateContent, ActionListener<UpdateResponse> updateListener) {
        this.getMemoryManager().updateInteraction(messageId, updateContent, updateListener);
    }

    public static class Factory
    implements Memory.Factory<ConversationIndexMemory> {
        private Client client;
        private MLIndicesHandler mlIndicesHandler;
        private String memoryMetaIndexName = ".plugins-ml-memory-meta";
        private String memoryMessageIndexName = ".plugins-ml-memory-message";
        private MLMemoryManager memoryManager;

        public void init(Client client, MLIndicesHandler mlIndicesHandler, MLMemoryManager memoryManager) {
            this.client = client;
            this.mlIndicesHandler = mlIndicesHandler;
            this.memoryManager = memoryManager;
        }

        public void create(Map<String, Object> map, ActionListener<ConversationIndexMemory> listener) {
            if (map == null || map.isEmpty()) {
                listener.onFailure((Exception)new IllegalArgumentException("Invalid input parameter for creating ConversationIndexMemory"));
                return;
            }
            String memoryId = (String)map.get(ConversationIndexMemory.MEMORY_ID);
            String name = (String)map.get(ConversationIndexMemory.MEMORY_NAME);
            String appType = (String)map.get(ConversationIndexMemory.APP_TYPE);
            this.create(name, memoryId, appType, listener);
        }

        public void create(String name, String memoryId, String appType, ActionListener<ConversationIndexMemory> listener) {
            if (Strings.isEmpty((CharSequence)memoryId)) {
                this.memoryManager.createConversation(name, appType, (ActionListener<CreateConversationResponse>)ActionListenerHelper.wrap(r -> {
                    this.create(r.getId(), listener);
                    log.debug("Created conversation on memory layer, conversation id: {}", (Object)r.getId());
                }, e -> {
                    log.error("Failed to save interaction", (Throwable)e);
                    listener.onFailure(e);
                }));
            } else {
                this.create(memoryId, listener);
            }
        }

        public void create(String memoryId, ActionListener<ConversationIndexMemory> listener) {
            listener.onResponse((Object)new ConversationIndexMemory(this.client, this.mlIndicesHandler, this.memoryMetaIndexName, this.memoryMessageIndexName, memoryId, this.memoryManager));
        }
    }
}

