/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.engine.memory;

import io.lucenia.ml.common.action.memory.conversation.CreateConversationAction;
import io.lucenia.ml.common.action.memory.conversation.CreateConversationRequest;
import io.lucenia.ml.common.action.memory.conversation.CreateConversationResponse;
import io.lucenia.ml.common.action.memory.conversation.CreateInteractionAction;
import io.lucenia.ml.common.action.memory.conversation.CreateInteractionRequest;
import io.lucenia.ml.common.action.memory.conversation.CreateInteractionResponse;
import io.lucenia.ml.common.action.memory.conversation.GetTracesAction;
import io.lucenia.ml.common.action.memory.conversation.GetTracesRequest;
import io.lucenia.ml.common.action.memory.conversation.UpdateInteractionAction;
import io.lucenia.ml.common.action.memory.conversation.UpdateInteractionRequest;
import io.lucenia.ml.common.conversation.ConversationMetaIndex;
import io.skylite.SkyliteSecurityException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.update.UpdateResponse;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.index.query.BoolQueryBuilder;
import io.skylite.core.index.query.ExistsQueryBuilder;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.index.query.TermQueryBuilder;
import io.skylite.core.search.SearchHit;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.core.search.sort.SortOrder;
import io.skylite.core.security.auth.User;
import io.skylite.ml.common.conversation.ConversationalIndexConstants;
import io.skylite.ml.common.conversation.Interaction;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.reindex.DeleteByQueryAction;
import org.opensearch.index.reindex.DeleteByQueryRequest;

public class MLMemoryManager {
    private static final Logger log = LogManager.getLogger(MLMemoryManager.class);
    private Client client;
    private ClusterService clusterService;
    private ConversationMetaIndex conversationMetaIndex;

    public MLMemoryManager(Client client, ClusterService clusterService, ConversationMetaIndex conversationMetaIndex) {
        this.client = client;
        this.clusterService = clusterService;
        this.conversationMetaIndex = conversationMetaIndex;
    }

    public void createConversation(String name, String applicationType, ActionListener<CreateConversationResponse> actionListener) {
        try {
            this.client.execute((ActionType)CreateConversationAction.INSTANCE, (ActionRequest)new CreateConversationRequest(name, applicationType), actionListener);
        }
        catch (Exception exception) {
            actionListener.onFailure(exception);
        }
    }

    public void createInteraction(String conversationId, String input, String promptTemplate, String response, String origin, Map<String, String> additionalInfo, String parentIntId, Integer traceNum, ActionListener<CreateInteractionResponse> actionListener) {
        Objects.requireNonNull(conversationId);
        Objects.requireNonNull(input);
        Objects.requireNonNull(response);
        additionalInfo = additionalInfo == null ? new HashMap<String, String>() : additionalInfo;
        try {
            this.client.execute((ActionType)CreateInteractionAction.INSTANCE, (ActionRequest)new CreateInteractionRequest(conversationId, input, promptTemplate, response, origin, additionalInfo, parentIntId, traceNum), actionListener);
        }
        catch (Exception exception) {
            actionListener.onFailure(exception);
        }
    }

    public void getFinalInteractions(String conversationId, int lastNInteraction, ActionListener<List<Interaction>> actionListener) {
        log.debug("Getting Interactions, conversationId {}, lastN {}", (Object)conversationId, (Object)lastNInteraction);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().newStoredContext(true);){
            if (!this.clusterService.state().metadata().hasIndex(ConversationalIndexConstants.INTERACTIONS_INDEX_NAME)) {
                actionListener.onResponse(List.of());
                return;
            }
            ActionListener accessListener = ActionListenerHelper.wrap(access -> {
                if (!access.booleanValue()) {
                    String userStr = (String)this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info");
                    String user = User.parse((String)userStr) == null ? "" : User.parse((String)userStr).getName();
                    throw new SkyliteSecurityException("User [" + user + "] does not have access to conversation " + conversationId, new Object[0]);
                }
                this.innerGetFinalInteractions(conversationId, lastNInteraction, actionListener);
            }, e -> actionListener.onFailure(e));
            this.conversationMetaIndex.checkAccess(conversationId, (ActionListener<Boolean>)accessListener);
        }
        catch (Exception e2) {
            log.error("Failed to get final interactions for conversation " + conversationId, (Throwable)e2);
            actionListener.onFailure(e2);
        }
    }

    void innerGetFinalInteractions(String conversationId, int lastNInteraction, ActionListener<List<Interaction>> listener) {
        SearchRequest searchRequest = new SearchRequest(new String[]{ConversationalIndexConstants.INTERACTIONS_INDEX_NAME});
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        ExistsQueryBuilder existsQueryBuilder = QueryBuilders.existsQuery((String)"trace_number");
        boolQueryBuilder.mustNot((QueryBuilder)existsQueryBuilder);
        TermQueryBuilder termQueryBuilder = QueryBuilders.termQuery((String)"memory_id", (String)conversationId);
        boolQueryBuilder.must((QueryBuilder)termQueryBuilder);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
        searchRequest.source(searchSourceBuilder);
        searchRequest.source().size(lastNInteraction);
        searchRequest.source().sort("create_time", SortOrder.DESC);
        try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener internalListener = ActionListenerHelper.runBefore(listener, () -> threadContext.restore());
            ActionListener al = ActionListenerHelper.wrap(response -> {
                LinkedList<Interaction> result = new LinkedList<Interaction>();
                for (SearchHit hit : response.getHits()) {
                    result.add(0, Interaction.fromSearchHit((SearchHit)hit));
                }
                internalListener.onResponse(result);
            }, e -> internalListener.onFailure(e));
            this.client.search(searchRequest, al);
        }
        catch (Exception e2) {
            listener.onFailure(e2);
        }
    }

    public void getTraces(String parentInteractionId, ActionListener<List<Interaction>> actionListener) {
        Objects.requireNonNull(parentInteractionId);
        log.debug("Getting traces for conversationId {}", (Object)parentInteractionId);
        ActionListener al = ActionListenerHelper.wrap(getTracesResponse -> actionListener.onResponse(getTracesResponse.getTraces()), e -> actionListener.onFailure(e));
        try {
            this.client.execute((ActionType)GetTracesAction.INSTANCE, (ActionRequest)new GetTracesRequest(parentInteractionId), al);
        }
        catch (Exception exception) {
            actionListener.onFailure(exception);
        }
    }

    public void updateInteraction(String interactionId, Map<String, Object> updateContent, ActionListener<UpdateResponse> actionListener) {
        Objects.requireNonNull(interactionId);
        Objects.requireNonNull(updateContent);
        try {
            this.client.execute((ActionType)UpdateInteractionAction.INSTANCE, (ActionRequest)new UpdateInteractionRequest(interactionId, updateContent), actionListener);
        }
        catch (Exception exception) {
            actionListener.onFailure(exception);
        }
    }

    public void deleteInteractionAndTrace(String interactionId, ActionListener<Boolean> listener) {
        DeleteByQueryRequest deleteByQueryRequest = new DeleteByQueryRequest(new String[]{ConversationalIndexConstants.INTERACTIONS_INDEX_NAME});
        deleteByQueryRequest.setQuery(this.buildDeleteInteractionQuery(interactionId));
        deleteByQueryRequest.setRefresh(true);
        this.innerDeleteInteractionAndTrace(deleteByQueryRequest, interactionId, listener);
    }

    void innerDeleteInteractionAndTrace(DeleteByQueryRequest deleteByQueryRequest, String interactionId, ActionListener<Boolean> listener) {
        try (ThreadContext.StoredContext ignored = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener al = ActionListenerHelper.wrap(bulkResponse -> {
                if (!(bulkResponse == null || bulkResponse.getBulkFailures().isEmpty() && bulkResponse.getSearchFailures().isEmpty())) {
                    log.info("Failed to delete the interaction with ID: {}", (Object)interactionId);
                    listener.onResponse((Object)false);
                    return;
                }
                log.info("Successfully delete the interaction with ID: {}", (Object)interactionId);
                listener.onResponse((Object)true);
            }, exception -> {
                log.error("Failed to delete interaction with ID {}. Details: {}", (Object)interactionId, exception);
                listener.onFailure(exception);
            });
            this.client.execute((ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)deleteByQueryRequest, al);
        }
        catch (Exception e) {
            log.error("Failed to delete interaction with ID {}. Details {}:", (Object)interactionId, (Object)e);
            listener.onFailure(e);
        }
    }

    QueryBuilder buildDeleteInteractionQuery(String interactionId) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.should((QueryBuilder)QueryBuilders.idsQuery().addIds(new String[]{interactionId}));
        BoolQueryBuilder traceBoolBuilder = QueryBuilders.boolQuery();
        ExistsQueryBuilder existsQueryBuilder = QueryBuilders.existsQuery((String)"trace_number");
        traceBoolBuilder.must((QueryBuilder)existsQueryBuilder);
        TermQueryBuilder termQueryBuilder = QueryBuilders.termQuery((String)"parent_message_id", (String)interactionId);
        traceBoolBuilder.must((QueryBuilder)termQueryBuilder);
        boolQueryBuilder.should((QueryBuilder)traceBoolBuilder);
        return boolQueryBuilder;
    }
}

