/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.engine.tools;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.client.Client;
import io.skylite.core.common.Strings;
import io.skylite.ml.common.FunctionName;
import io.skylite.ml.common.dataset.MLInputDataset;
import io.skylite.ml.common.dataset.remote.RemoteInferenceInputDataSet;
import io.skylite.ml.common.engine.tools.Tool;
import io.skylite.ml.common.engine.tools.ToolAnnotation;
import io.skylite.ml.common.input.Input;
import io.skylite.ml.common.input.execute.agent.AgentMLInput;
import io.skylite.ml.common.output.model.ModelTensorOutput;
import io.skylite.ml.common.transport.execute.MLExecuteTaskAction;
import io.skylite.ml.common.transport.execute.MLExecuteTaskRequest;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ToolAnnotation(value="AgentTool")
public class AgentTool
implements Tool {
    private static final Logger log = LogManager.getLogger(AgentTool.class);
    public static final String TYPE = "AgentTool";
    private final Client client;
    private String agentId;
    private String name = "AgentTool";
    private Map<String, Object> attributes;
    static String DEFAULT_DESCRIPTION = "Use this tool to run any agent.";
    private String description = DEFAULT_DESCRIPTION;

    public AgentTool(Client client, String agentId) {
        this.client = client;
        this.agentId = agentId;
    }

    public <T> void run(Map<String, String> parameters, ActionListener<T> listener) {
        Map<String, String> extractedParameters = this.extractInputParameters(parameters);
        String tenantId = parameters.get("tenant_id");
        AgentMLInput agentMLInput = AgentMLInput.AgentMLInputBuilder().agentId(this.agentId).tenantId(tenantId).algorithm(FunctionName.AGENT).inputDataset((MLInputDataset)RemoteInferenceInputDataSet.builder().parameters(extractedParameters).build()).build();
        MLExecuteTaskRequest request = new MLExecuteTaskRequest(FunctionName.AGENT, (Input)agentMLInput, false);
        this.client.execute((ActionType)MLExecuteTaskAction.INSTANCE, (ActionRequest)request, ActionListenerHelper.wrap(r -> {
            ModelTensorOutput output = (ModelTensorOutput)r.getOutput();
            listener.onResponse((Object)output);
        }, e -> {
            log.error("Failed to run agent " + this.agentId, (Throwable)e);
            listener.onFailure(e);
        }));
    }

    public String getType() {
        return TYPE;
    }

    public String getVersion() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String s) {
        this.name = s;
    }

    public boolean validate(Map<String, String> parameters) {
        return true;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    private Map<String, String> extractInputParameters(Map<String, String> parameters) {
        HashMap<String, String> extractedParameters = new HashMap<String, String>();
        extractedParameters.putAll(parameters);
        if (parameters.containsKey("input")) {
            try {
                Map chatParameters = (Map)Strings.fromJson((String)parameters.get("input"), Map.class);
                extractedParameters.putAll(chatParameters);
            }
            catch (Exception exception) {
                log.info("fail extract parameters from key 'input' due to" + exception.getMessage());
            }
        }
        return extractedParameters;
    }

    public static class Factory
    implements Tool.Factory<AgentTool> {
        private Client client;
        private static Factory INSTANCE;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Factory getInstance() {
            if (INSTANCE != null) {
                return INSTANCE;
            }
            Class<AgentTool> clazz = AgentTool.class;
            synchronized (AgentTool.class) {
                if (INSTANCE != null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return INSTANCE;
                }
                INSTANCE = new Factory();
                // ** MonitorExit[var0] (shouldn't be in output)
                return INSTANCE;
            }
        }

        public void init(Client client) {
            this.client = client;
        }

        public AgentTool create(Map<String, Object> map) {
            return new AgentTool(this.client, (String)map.get("agent_id"));
        }

        public String getDefaultDescription() {
            return DEFAULT_DESCRIPTION;
        }

        public String getDefaultType() {
            return AgentTool.TYPE;
        }

        public String getDefaultVersion() {
            return null;
        }
    }
}

