/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.engine.tools;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.client.Client;
import io.skylite.ml.common.FunctionName;
import io.skylite.ml.common.dataset.MLInputDataset;
import io.skylite.ml.common.dataset.remote.RemoteInferenceInputDataSet;
import io.skylite.ml.common.engine.tools.Parser;
import io.skylite.ml.common.engine.tools.Tool;
import io.skylite.ml.common.engine.tools.ToolAnnotation;
import io.skylite.ml.common.input.MLInput;
import io.skylite.ml.common.input.remote.RemoteInferenceMLInput;
import io.skylite.ml.common.output.model.ModelTensor;
import io.skylite.ml.common.output.model.ModelTensorOutput;
import io.skylite.ml.common.output.model.ModelTensors;
import io.skylite.ml.common.transport.connector.MLExecuteConnectorAction;
import io.skylite.ml.common.transport.connector.MLExecuteConnectorRequest;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ToolAnnotation(value="ConnectorTool")
public class ConnectorTool
implements Tool {
    private static final Logger log = LogManager.getLogger(ConnectorTool.class);
    public static final String TYPE = "ConnectorTool";
    public static final String CONNECTOR_ID = "connector_id";
    public static final String CONNECTOR_ACTION = "connector_action";
    private String name = "ConnectorTool";
    private String description = "This tool will invoke external service.";
    private String version;
    private Parser inputParser;
    private Parser outputParser;
    private Map<String, Object> attributes;
    private Client client;
    private String connectorId;

    public ConnectorTool(Client client, String connectorId) {
        this.client = client;
        if (connectorId == null) {
            throw new IllegalArgumentException("connector_id can't be null");
        }
        this.connectorId = connectorId;
        this.outputParser = new Parser(this){

            public Object parse(Object o) {
                List mlModelOutputs = (List)o;
                return ((ModelTensor)((ModelTensors)mlModelOutputs.get(0)).getMlModelTensors().get(0)).getDataAsMap().get("response");
            }
        };
    }

    public <T> void run(Map<String, String> parameters, ActionListener<T> listener) {
        RemoteInferenceInputDataSet inputDataSet = RemoteInferenceInputDataSet.builder().parameters(parameters).build();
        MLInput mlInput = RemoteInferenceMLInput.builder().algorithm(FunctionName.CONNECTOR).inputDataset((MLInputDataset)inputDataSet).build();
        MLExecuteConnectorRequest request = new MLExecuteConnectorRequest(this.connectorId, mlInput);
        this.client.execute((ActionType)MLExecuteConnectorAction.INSTANCE, (ActionRequest)request, ActionListenerHelper.wrap(r -> {
            ModelTensorOutput modelTensorOutput = (ModelTensorOutput)r.getOutput();
            modelTensorOutput.getMlModelOutputs();
            if (this.outputParser == null) {
                listener.onResponse((Object)modelTensorOutput.getMlModelOutputs());
            } else {
                listener.onResponse(this.outputParser.parse((Object)modelTensorOutput.getMlModelOutputs()));
            }
        }, e -> {
            log.error("Failed to run model " + this.connectorId, (Throwable)e);
            listener.onFailure(e);
        }));
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public String getType() {
        return TYPE;
    }

    public boolean validate(Map<String, String> parameters) {
        return parameters != null && parameters.size() != 0;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setInputParser(Parser inputParser) {
        this.inputParser = inputParser;
    }

    public void setOutputParser(Parser outputParser) {
        this.outputParser = outputParser;
    }

    public String getVersion() {
        return this.version;
    }

    public static class Factory
    implements Tool.Factory<ConnectorTool> {
        public static final String TYPE = "ConnectorTool";
        public static final String DEFAULT_DESCRIPTION = "This tool will invoke external service.";
        private Client client;
        private static Factory INSTANCE;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Factory getInstance() {
            if (INSTANCE != null) {
                return INSTANCE;
            }
            Class<ConnectorTool> clazz = ConnectorTool.class;
            synchronized (ConnectorTool.class) {
                if (INSTANCE != null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return INSTANCE;
                }
                INSTANCE = new Factory();
                // ** MonitorExit[var0] (shouldn't be in output)
                return INSTANCE;
            }
        }

        public void init(Client client) {
            this.client = client;
        }

        public ConnectorTool create(Map<String, Object> map) {
            return new ConnectorTool(this.client, (String)map.get(ConnectorTool.CONNECTOR_ID));
        }

        public String getDefaultDescription() {
            return DEFAULT_DESCRIPTION;
        }

        public String getDefaultType() {
            return "ConnectorTool";
        }

        public String getDefaultVersion() {
            return null;
        }
    }
}

