/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.engine.tools;

import io.modelcontextprotocol.client.McpSyncClient;
import io.modelcontextprotocol.spec.McpSchema;
import io.skylite.common.action.ActionListener;
import io.skylite.core.common.Strings;
import io.skylite.ml.common.engine.tools.Parser;
import io.skylite.ml.common.engine.tools.ToolAnnotation;
import io.skylite.ml.common.engine.tools.WithModelTool;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ToolAnnotation(value="McpSseTool")
public class McpSseTool
implements WithModelTool {
    private static final Logger log = LoggerFactory.getLogger(McpSseTool.class);
    public static final String TYPE = "McpSseTool";
    private String name = "McpSseTool";
    private Map<String, Object> attributes;
    public static String DEFAULT_DESCRIPTION = "A tool from MCP Server";
    private String description = DEFAULT_DESCRIPTION;
    private McpSyncClient mcpSyncClient;
    private Parser<?, ?> inputParser;
    private Parser<?, ?> outputParser;

    public McpSseTool(McpSyncClient mcpSyncClient) {
        this.mcpSyncClient = mcpSyncClient;
    }

    public <T> void run(Map<String, String> originalParameters, ActionListener<T> listener) {
        try {
            Map<String, String> parameters = originalParameters;
            String input = parameters.get("input");
            Map inputArgs = Strings.fromJson((String)input, (String)"input");
            McpSchema.CallToolResult result = this.mcpSyncClient.callTool(new McpSchema.CallToolRequest(this.name, inputArgs));
            String resultJson = Strings.toJson((Object)result.content());
            listener.onResponse((Object)resultJson);
        }
        catch (Exception e) {
            log.error("Failed to call MCP tool: {}", (Object)this.getName(), (Object)e);
            listener.onFailure(e);
        }
    }

    public String getType() {
        return TYPE;
    }

    public String getVersion() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String s) {
        this.name = s;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public McpSyncClient getMcpSyncClient() {
        return this.mcpSyncClient;
    }

    public void setInputParser(Parser<?, ?> inputParser) {
        this.inputParser = inputParser;
    }

    public Parser<?, ?> getOutputParser() {
        return this.outputParser;
    }

    public void setOutputParser(Parser<?, ?> outputParser) {
        this.outputParser = outputParser;
    }

    public boolean validate(Map<String, String> parameters) {
        return parameters != null && parameters.size() != 0;
    }

    public static class Factory
    implements WithModelTool.Factory<McpSseTool> {
        private static Factory INSTANCE;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Factory getInstance() {
            if (INSTANCE != null) {
                return INSTANCE;
            }
            Class<McpSseTool> clazz = McpSseTool.class;
            synchronized (McpSseTool.class) {
                if (INSTANCE != null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return INSTANCE;
                }
                INSTANCE = new Factory();
                // ** MonitorExit[var0] (shouldn't be in output)
                return INSTANCE;
            }
        }

        public void init() {
        }

        public McpSseTool create(Map<String, Object> map) {
            return new McpSseTool((McpSyncClient)map.get("mcp_sync_client"));
        }

        public String getDefaultDescription() {
            return DEFAULT_DESCRIPTION;
        }

        public String getDefaultType() {
            return McpSseTool.TYPE;
        }

        public String getDefaultVersion() {
            return null;
        }

        public List<String> getAllModelKeys() {
            return List.of();
        }
    }
}

