/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.model;

import io.skylite.core.index.query.BoolQueryBuilder;
import io.skylite.core.index.query.ExistsQueryBuilder;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.index.query.TermQueryBuilder;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.ml.common.engine.tools.Tool;
import io.skylite.ml.common.engine.tools.WithModelTool;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.opensearch.index.query.TermsQueryBuilder;

public class AgentModelsSearcher {
    private final Set<String> relatedModelIdSet = new HashSet<String>();

    public AgentModelsSearcher(Map<String, Tool.Factory<?>> toolFactories) {
        for (Map.Entry<String, Tool.Factory<?>> entry : toolFactories.entrySet()) {
            Tool.Factory<?> toolFactory = entry.getValue();
            if (!(toolFactory instanceof WithModelTool.Factory)) continue;
            WithModelTool.Factory withModelTool = (WithModelTool.Factory)toolFactory;
            this.relatedModelIdSet.addAll(withModelTool.getAllModelKeys());
        }
    }

    public SearchRequest constructQueryRequestToSearchModelIdInsideAgent(String candidateModelId) {
        SearchRequest searchRequest = new SearchRequest(new String[]{".plugins-ml-agent"});
        BoolQueryBuilder searchAgentQuery = new BoolQueryBuilder();
        BoolQueryBuilder hiddenFieldQuery = new BoolQueryBuilder();
        hiddenFieldQuery.should((QueryBuilder)new BoolQueryBuilder().mustNot((QueryBuilder)new ExistsQueryBuilder("is_hidden")));
        BoolQueryBuilder existHiddenFieldQuery = new BoolQueryBuilder();
        existHiddenFieldQuery.must((QueryBuilder)new TermQueryBuilder("is_hidden", false));
        existHiddenFieldQuery.must((QueryBuilder)new ExistsQueryBuilder("is_hidden"));
        hiddenFieldQuery.should((QueryBuilder)existHiddenFieldQuery);
        BoolQueryBuilder modelIdQuery = new BoolQueryBuilder();
        for (String keyField : this.relatedModelIdSet) {
            modelIdQuery.should((QueryBuilder)new TermsQueryBuilder("tools.parameters." + keyField, new String[]{candidateModelId}));
        }
        searchAgentQuery.must((QueryBuilder)hiddenFieldQuery);
        searchAgentQuery.must((QueryBuilder)modelIdQuery);
        searchRequest.source(new SearchSourceBuilder().query((QueryBuilder)searchAgentQuery));
        return searchRequest;
    }
}

