/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.permission;

import io.skylite.core.client.Client;
import io.skylite.core.security.auth.User;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AccessController {
    private static final Logger log = LogManager.getLogger(AccessController.class);

    public static String getUserStr(Client client) {
        return (String)client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info");
    }

    public static User getUserContext(Client client) {
        return User.parse((String)AccessController.getUserStr(client));
    }

    public static boolean checkUserPermissions(User requestedUser, User resourceUser, String modelId) {
        if (requestedUser == null || resourceUser == null) {
            return true;
        }
        if (resourceUser.getBackendRoles() == null || requestedUser.getBackendRoles() == null) {
            return false;
        }
        for (String backendRole : requestedUser.getBackendRoles()) {
            if (!resourceUser.getBackendRoles().contains(backendRole)) continue;
            log.debug("User: " + requestedUser.getName() + " has backend role: " + backendRole + " permissions to access model: " + modelId);
            return true;
        }
        return false;
    }
}

