/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.remote;

import io.skylite.core.common.io.stream.BytesStreamOutput;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.security.auth.User;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.ml.common.AccessMode;
import io.skylite.ml.common.annotation.Connector;
import io.skylite.ml.common.connector.ConnectorAction;
import io.skylite.ml.common.connector.ConnectorClientConfig;
import io.skylite.ml.common.connector.HttpConnector;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Connector(value="aws_sigv4")
public class AWSConnector
extends HttpConnector {
    private static final Logger log = LogManager.getLogger(AWSConnector.class);

    public AWSConnector() {
    }

    public AWSConnector(String name, String description, String version, String protocol, Map<String, String> parameters, Map<String, String> credential, List<ConnectorAction> actions, List<String> backendRoles, AccessMode accessMode, User owner, ConnectorClientConfig connectorClientConfig, String tenantId) {
        super(name, description, version, protocol, parameters, credential, actions, backendRoles, accessMode, owner, connectorClientConfig, tenantId);
        this.validate();
    }

    public AWSConnector(String protocol, XContentParser parser) throws IOException {
        super(protocol, parser);
        this.validate();
    }

    public AWSConnector(StreamInput input) throws IOException {
        super(input);
        this.validate();
    }

    private void validate() {
        if (this.credential == null || !this.credential.containsKey("access_key") || !this.credential.containsKey("secret_key")) {
            throw new IllegalArgumentException("Missing credential");
        }
        if (!(this.credential != null && this.credential.containsKey("service_name") || this.parameters != null && this.parameters.containsKey("service_name"))) {
            throw new IllegalArgumentException("Missing service name");
        }
        if (!(this.credential != null && this.credential.containsKey("region") || this.parameters != null && this.parameters.containsKey("region"))) {
            throw new IllegalArgumentException("Missing region");
        }
    }

    public io.skylite.ml.common.connector.Connector cloneConnector() {
        AWSConnector aWSConnector;
        BytesStreamOutput bytesStreamOutput = new BytesStreamOutput();
        try {
            this.writeTo((StreamOutput)bytesStreamOutput);
            StreamInput streamInput = bytesStreamOutput.bytes().streamInput();
            aWSConnector = new AWSConnector(streamInput);
        }
        catch (Throwable throwable) {
            try {
                try {
                    bytesStreamOutput.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        bytesStreamOutput.close();
        return aWSConnector;
    }

    public String getAccessKey() {
        return (String)this.decryptedCredential.get("access_key");
    }

    public String getSecretKey() {
        return (String)this.decryptedCredential.get("secret_key");
    }

    public String getSessionToken() {
        return (String)this.decryptedCredential.get("session_token");
    }

    public String getServiceName() {
        if (this.parameters == null) {
            return (String)this.decryptedCredential.get("service_name");
        }
        return Optional.ofNullable((String)this.parameters.get("service_name")).orElse((String)this.decryptedCredential.get("service_name"));
    }

    public String getRegion() {
        if (this.parameters == null) {
            return (String)this.decryptedCredential.get("region");
        }
        return Optional.ofNullable((String)this.parameters.get("region")).orElse((String)this.decryptedCredential.get("region"));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public static Builder awsConnectorBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private String description;
        private String version;
        private String protocol;
        private Map<String, String> parameters;
        private Map<String, String> credential;
        private List<ConnectorAction> actions;
        private List<String> backendRoles;
        private AccessMode accessMode;
        private User owner;
        private ConnectorClientConfig connectorClientConfig;
        private String tenantId;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder parameters(Map<String, String> parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder credential(Map<String, String> credential) {
            this.credential = credential;
            return this;
        }

        public Builder actions(List<ConnectorAction> actions) {
            this.actions = actions;
            return this;
        }

        public Builder backendRoles(List<String> backendRoles) {
            this.backendRoles = backendRoles;
            return this;
        }

        public Builder accessMode(AccessMode accessMode) {
            this.accessMode = accessMode;
            return this;
        }

        public Builder owner(User owner) {
            this.owner = owner;
            return this;
        }

        public Builder connectorClientConfig(ConnectorClientConfig connectorClientConfig) {
            this.connectorClientConfig = connectorClientConfig;
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public AWSConnector build() {
            return new AWSConnector(this.name, this.description, this.version, this.protocol, this.parameters, this.credential, this.actions, this.backendRoles, this.accessMode, this.owner, this.connectorClientConfig, this.tenantId);
        }
    }
}

