/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.remote;

import io.lucenia.ml.common.http.AwsSigV4HttpRequestSigner;
import io.lucenia.ml.common.remote.AWSConnector;
import io.lucenia.ml.common.remote.AbstractConnectorExecutor;
import io.lucenia.ml.common.remote.MLAwsSdkAsyncHttpResponseHandler;
import io.skylite.common.TokenBucket;
import io.skylite.common.action.ActionListener;
import io.skylite.common.collect.Tuple;
import io.skylite.core.script.ScriptService;
import io.skylite.ml.common.annotation.ConnectorExecutor;
import io.skylite.ml.common.connector.Connector;
import io.skylite.ml.common.connector.ConnectorClientConfig;
import io.skylite.ml.common.exception.MLException;
import io.skylite.ml.common.input.MLInput;
import io.skylite.ml.common.model.MLGuard;
import io.skylite.ml.common.output.model.ModelTensors;
import io.skylite.ml.common.remote.ExecutionContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.time.Duration;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import software.amazon.awssdk.core.internal.http.async.SimpleHttpContentPublisher;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.async.AsyncExecuteRequest;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.async.SdkAsyncHttpResponseHandler;
import software.amazon.awssdk.http.async.SdkHttpContentPublisher;
import software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;

@ConnectorExecutor(value="aws_sigv4")
public class AWSConnectorExecutor
extends AbstractConnectorExecutor {
    private static final Logger log = LogManager.getLogger(AWSConnectorExecutor.class);
    private final AWSConnector connector;
    private final AwsSigV4HttpRequestSigner signer;
    private ScriptService scriptService;
    private TokenBucket rateLimiter;
    private Map<String, TokenBucket> userRateLimiterMap;
    private MLGuard mlGuard;
    private volatile AtomicBoolean connectorPrivateIpEnabled;
    private SdkAsyncHttpClient httpClient;

    public AWSConnectorExecutor(Connector connector) {
        super.initialize(connector);
        this.connector = (AWSConnector)connector;
        this.signer = new AwsSigV4HttpRequestSigner();
        this.httpClient = AWSConnectorExecutor.buildHttpClient(super.getConnectorClientConfig());
    }

    private static SdkAsyncHttpClient buildHttpClient(ConnectorClientConfig config) {
        Duration connectionTimeout = Duration.ofSeconds(config.getConnectionTimeout());
        Duration readTimeout = Duration.ofSeconds(config.getReadTimeout());
        int maxConnections = config.getMaxConnections() > 0 ? config.getMaxConnections() : 30;
        try {
            return AccessController.doPrivileged(() -> NettyNioAsyncHttpClient.builder().connectionTimeout(connectionTimeout).readTimeout(readTimeout).maxConcurrency(Integer.valueOf(maxConnections)).build());
        }
        catch (PrivilegedActionException e) {
            throw new IllegalStateException("Failed to create AWS SDK Netty async HTTP client", e);
        }
    }

    public AWSConnector getConnector() {
        return this.connector;
    }

    public ScriptService getScriptService() {
        return this.scriptService;
    }

    public void setScriptService(ScriptService scriptService) {
        this.scriptService = scriptService;
    }

    public TokenBucket getRateLimiter() {
        return this.rateLimiter;
    }

    public void setRateLimiter(TokenBucket rateLimiter) {
        this.rateLimiter = rateLimiter;
    }

    public Map<String, TokenBucket> getUserRateLimiterMap() {
        return this.userRateLimiterMap;
    }

    public void setUserRateLimiterMap(Map<String, TokenBucket> userRateLimiterMap) {
        this.userRateLimiterMap = userRateLimiterMap;
    }

    public MLGuard getMlGuard() {
        return this.mlGuard;
    }

    public void setMlGuard(MLGuard mlGuard) {
        this.mlGuard = mlGuard;
    }

    public void setConnectorPrivateIpEnabled(AtomicBoolean connectorPrivateIpEnabled) {
        this.connectorPrivateIpEnabled = connectorPrivateIpEnabled;
    }

    public Logger getLogger() {
        return log;
    }

    public void invokeRemoteService(String action, MLInput mlInput, Map<String, String> parameters, String payload, ExecutionContext executionContext, ActionListener<Tuple<Integer, ModelTensors>> actionListener) {
        try {
            SdkHttpFullRequest signedRequest = this.signRequest(switch (this.connector.getActionHttpMethod(action).toUpperCase(Locale.ROOT)) {
                case "POST" -> {
                    log.debug("original payload to remote model: {}", (Object)payload);
                    yield this.signer.buildSdkRequest(action, (Connector)this.connector, parameters, payload, SdkHttpMethod.POST);
                }
                case "GET" -> this.signer.buildSdkRequest(action, (Connector)this.connector, parameters, null, SdkHttpMethod.GET);
                default -> throw new IllegalArgumentException("unsupported http method");
            });
            AsyncExecuteRequest executeRequest = AsyncExecuteRequest.builder().request((SdkHttpRequest)signedRequest).requestContentPublisher((SdkHttpContentPublisher)new SimpleHttpContentPublisher(signedRequest)).responseHandler((SdkAsyncHttpResponseHandler)new MLAwsSdkAsyncHttpResponseHandler(executionContext, actionListener, parameters, (Connector)this.connector, this.scriptService, this.mlGuard, action)).build();
            AccessController.doPrivileged(() -> this.httpClient.execute(executeRequest));
        }
        catch (RuntimeException exception) {
            log.error("Failed to execute " + action + " in aws connector: " + exception.getMessage(), (Throwable)exception);
            actionListener.onFailure((Exception)exception);
        }
        catch (Throwable e) {
            log.error("Failed to execute " + action + " in aws connector", e);
            actionListener.onFailure((Exception)new MLException("Fail to execute " + action + " in aws connector", e));
        }
    }

    private SdkHttpFullRequest signRequest(SdkHttpFullRequest request) {
        String accessKey = this.connector.getAccessKey();
        String secretKey = this.connector.getSecretKey();
        String sessionToken = this.connector.getSessionToken();
        String signingName = this.connector.getServiceName();
        String region = this.connector.getRegion();
        return this.signer.signSdkRequest(request, accessKey, secretKey, sessionToken, signingName, region);
    }
}

