/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.remote;

import io.lucenia.ml.common.remote.MLSdkAsyncHttpResponseHandler;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;

public class MLHttp5AsyncResponseConsumer
implements AsyncResponseConsumer<SimpleHttpResponse> {
    private final MLSdkAsyncHttpResponseHandler responseHandler;
    private final StringBuilder responseBody = new StringBuilder();
    private final AtomicReference<Exception> exceptionHolder = new AtomicReference();
    private FutureCallback<SimpleHttpResponse> resultCallback;
    private HttpResponse response;

    public MLHttp5AsyncResponseConsumer(MLSdkAsyncHttpResponseHandler responseHandler) {
        this.responseHandler = (MLSdkAsyncHttpResponseHandler)((Object)Args.notNull((Object)((Object)responseHandler), (String)"Response Handler"));
    }

    public void consumeResponse(HttpResponse response, EntityDetails entityDetails, HttpContext context, FutureCallback<SimpleHttpResponse> resultCallback) {
        this.response = response;
        this.resultCallback = resultCallback;
        int statusCode = response.getCode();
        StringBuilder headers = new StringBuilder();
        for (Header header : response.getHeaders()) {
            headers.append(header.getName()).append(": ").append(header.getValue()).append("\n");
        }
        this.responseHandler.handleResponseHeaders(statusCode, headers.toString());
        if (entityDetails == null) {
            this.completeResponse();
        }
    }

    public void informationResponse(HttpResponse response, HttpContext context) throws HttpException, IOException {
        int statusCode = response.getCode();
        if (statusCode >= 100 && statusCode < 200) {
            this.responseHandler.handleResponseHeaders(statusCode, "Intermediate response received.");
        }
    }

    public void updateCapacity(CapacityChannel capacityChannel) throws IOException {
        capacityChannel.update(Integer.MAX_VALUE);
    }

    public void consume(ByteBuffer src) throws IOException {
        byte[] bytes = new byte[src.remaining()];
        src.get(bytes);
        this.responseBody.append(new String(bytes, StandardCharsets.UTF_8));
    }

    public void streamEnd(List<? extends Header> trailers) throws HttpException, IOException {
        this.completeResponse();
    }

    public void failed(Exception ex) {
        if (this.resultCallback != null) {
            this.resultCallback.failed(ex);
        }
        this.responseHandler.handleFailure(ex);
    }

    public void releaseResources() {
        this.responseBody.setLength(0);
    }

    private void completeResponse() {
        try {
            this.responseHandler.processResponse(this.responseBody.toString());
            if (this.resultCallback != null) {
                this.resultCallback.completed((Object)new SimpleHttpResponse(this.response.getCode(), this.response.getReasonPhrase()));
            }
        }
        catch (Exception e) {
            this.failed(e);
        }
    }
}

