/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.remote;

import io.lucenia.ml.common.engine.tools.McpSseTool;
import io.modelcontextprotocol.client.McpClient;
import io.modelcontextprotocol.client.McpSyncClient;
import io.modelcontextprotocol.client.transport.HttpClientSseClientTransport;
import io.modelcontextprotocol.spec.McpClientTransport;
import io.modelcontextprotocol.spec.McpSchema;
import io.skylite.common.TokenBucket;
import io.skylite.common.action.ActionListener;
import io.skylite.common.collect.Tuple;
import io.skylite.core.client.Client;
import io.skylite.core.common.Strings;
import io.skylite.core.script.ScriptService;
import io.skylite.ml.common.agent.MLToolSpec;
import io.skylite.ml.common.annotation.ConnectorExecutor;
import io.skylite.ml.common.connector.Connector;
import io.skylite.ml.common.connector.McpConnector;
import io.skylite.ml.common.exception.MLException;
import io.skylite.ml.common.input.MLInput;
import io.skylite.ml.common.model.MLGuard;
import io.skylite.ml.common.output.model.ModelTensors;
import io.skylite.ml.common.remote.AbstractConnectorExecutor;
import io.skylite.ml.common.remote.ExecutionContext;
import java.net.http.HttpRequest;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ConnectorExecutor(value="mcp_streamable_http")
public class McpConnectorExecutor
extends AbstractConnectorExecutor {
    private static final Logger log = LogManager.getLogger(McpConnectorExecutor.class);
    private McpConnector connector;
    private TokenBucket rateLimiter;
    private Map<String, TokenBucket> userRateLimiterMap;
    private MLGuard mlGuard;

    public McpConnector getConnector() {
        return this.connector;
    }

    public void setRateLimiter(TokenBucket rateLimiter) {
        this.rateLimiter = rateLimiter;
    }

    public TokenBucket getRateLimiter() {
        return this.rateLimiter;
    }

    public void setUserRateLimiterMap(Map<String, TokenBucket> userRateLimiterMap) {
        this.userRateLimiterMap = userRateLimiterMap;
    }

    public Map<String, TokenBucket> getUserRateLimiterMap() {
        return this.userRateLimiterMap;
    }

    public void setMLGuard(MLGuard mlGuard) {
        this.mlGuard = mlGuard;
    }

    public MLGuard getMlGuard() {
        return this.mlGuard;
    }

    public McpConnectorExecutor(Connector connector) {
        super.initialize(connector);
        this.connector = (McpConnector)connector;
    }

    public List<MLToolSpec> getMcpToolSpecs() {
        String sseEndpoint;
        String mcpServerUrl = this.connector.getUrl();
        String string = sseEndpoint = this.connector.getParameters() != null && this.connector.getParameters().containsKey("endpoint") ? (String)this.connector.getParameters().get("endpoint") : "/mcp/";
        if (mcpServerUrl == null) {
            return Collections.emptyList();
        }
        ArrayList<MLToolSpec> mcpToolSpecs = new ArrayList<MLToolSpec>();
        try {
            Duration connectionTimeout = Duration.ofSeconds(super.getConnectorClientConfig().getConnectionTimeout());
            Duration readTimeout = Duration.ofSeconds(super.getConnectorClientConfig().getReadTimeout());
            Consumer<HttpRequest.Builder> headerConfig = builder -> {
                for (Map.Entry entry : this.connector.getDecryptedHeaders().entrySet()) {
                    builder.header((String)entry.getKey(), (String)entry.getValue());
                }
            };
            HttpClientSseClientTransport transport = HttpClientSseClientTransport.builder((String)mcpServerUrl).sseEndpoint(sseEndpoint).customizeClient(clientBuilder -> clientBuilder.connectTimeout(connectionTimeout)).customizeRequest(headerConfig).build();
            McpSyncClient client = McpClient.sync((McpClientTransport)transport).requestTimeout(readTimeout).capabilities(McpSchema.ClientCapabilities.builder().roots(Boolean.valueOf(false)).build()).build();
            client.initialize();
            McpSchema.ListToolsResult tools = client.listTools();
            String json = Strings.toJson((Object)tools);
            Map map = (Map)Strings.fromJson((String)json, Map.class);
            List mcpTools = (List)map.get("tools");
            for (Object tool : mcpTools) {
                Map toolMap = (Map)tool;
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("input_schema", Strings.toJson(toolMap.get("inputSchema")));
                String description = toolMap.containsKey("description") ? toolMap.get("description").toString() : McpSseTool.DEFAULT_DESCRIPTION;
                MLToolSpec mlToolSpec = MLToolSpec.builder().type("McpSseTool").name(toolMap.get("name").toString()).description(description).parameters(parameters).build();
                mlToolSpec.addRuntimeResource("mcp_sync_client", (Object)client);
                mcpToolSpecs.add(mlToolSpec);
            }
            return mcpToolSpecs;
        }
        catch (Exception e) {
            throw new MLException("Unexpected error while getting MCP tools", (Throwable)e);
        }
    }

    public ScriptService getScriptService() {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public Client getClient() {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public Logger getLogger() {
        return log;
    }

    public void invokeRemoteService(String action, MLInput mlInput, Map<String, String> parameters, String payload, ExecutionContext executionContext, ActionListener<Tuple<Integer, ModelTensors>> actionListener) {
        throw new UnsupportedOperationException("Not implemented.");
    }
}

