/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.remote;

import io.lucenia.ml.common.remote.AbstractConnectorExecutor;
import io.skylite.common.TokenBucket;
import io.skylite.common.action.ActionListener;
import io.skylite.core.client.Client;
import io.skylite.core.client.ReleasableSkyliteClient;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.script.ScriptService;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.ml.common.FunctionName;
import io.skylite.ml.common.annotation.Function;
import io.skylite.ml.common.connector.Connector;
import io.skylite.ml.common.connector.ConnectorAction;
import io.skylite.ml.common.dataset.remote.RemoteInferenceInputDataSet;
import io.skylite.ml.common.engine.Encryptor;
import io.skylite.ml.common.engine.MLEngineClassLoader;
import io.skylite.ml.common.engine.Predictable;
import io.skylite.ml.common.exception.MLException;
import io.skylite.ml.common.input.MLInput;
import io.skylite.ml.common.model.MLGuard;
import io.skylite.ml.common.model.MLModel;
import io.skylite.ml.common.output.MLOutput;
import io.skylite.ml.common.transport.MLTaskResponse;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Function(value=FunctionName.REMOTE)
public class RemoteModel
implements Predictable {
    private static final Logger log = LogManager.getLogger(RemoteModel.class);
    public static final String CLUSTER_SERVICE = "cluster_service";
    public static final String SCRIPT_SERVICE = "script_service";
    public static final String CLIENT = "client";
    public static final String XCONTENT_REGISTRY = "xcontent_registry";
    public static final String RATE_LIMITER = "rate_limiter";
    public static final String USER_RATE_LIMITER_MAP = "user_rate_limiter_map";
    public static final String GUARDRAILS = "guardrails";
    public static final String CONNECTOR_PRIVATE_IP_ENABLED = "connectorPrivateIpEnabled";
    private AbstractConnectorExecutor connectorExecutor;

    AbstractConnectorExecutor getConnectorExecutor() {
        return this.connectorExecutor;
    }

    public MLOutput predict(MLInput mlInput, MLModel model) {
        throw new IllegalArgumentException("Model not ready yet. Please run this first: POST /_plugins/_ml/models/" + model.getModelId() + "/_deploy");
    }

    public void asyncPredict(MLInput mlInput, ActionListener<MLTaskResponse> actionListener) {
        if (!this.isModelReady()) {
            actionListener.onFailure((Exception)new IllegalArgumentException("Model not ready yet. Please run this first: POST /_plugins/_ml/models/<model_id>/_deploy"));
            return;
        }
        try {
            ConnectorAction.ActionType actionType = null;
            if (mlInput.getInputDataset() instanceof RemoteInferenceInputDataSet) {
                actionType = ((RemoteInferenceInputDataSet)mlInput.getInputDataset()).getActionType();
            }
            actionType = actionType == null ? ConnectorAction.ActionType.PREDICT : actionType;
            this.connectorExecutor.executeAction(actionType.toString(), mlInput, actionListener);
        }
        catch (RuntimeException e) {
            log.error("Failed to call remote model.", (Throwable)e);
            actionListener.onFailure((Exception)e);
        }
        catch (Throwable e) {
            log.error("Failed to call remote model.", e);
            actionListener.onFailure((Exception)new MLException(e));
        }
    }

    public void close() {
        this.connectorExecutor = null;
    }

    public boolean isModelReady() {
        return this.connectorExecutor != null;
    }

    public void initModel(MLModel model, Map<String, Object> params, Encryptor encryptor) {
        try {
            Connector connector = model.getConnector().cloneConnector();
            connector.decrypt(ConnectorAction.ActionType.PREDICT.name(), (credential, tenantId) -> encryptor.decrypt(credential, model.getTenantId()), model.getTenantId());
            this.connectorExecutor = (AbstractConnectorExecutor)MLEngineClassLoader.initInstance((Object)connector.getProtocol(), (Object)connector, Connector.class);
            this.connectorExecutor.setScriptService((ScriptService)params.get(SCRIPT_SERVICE));
            this.connectorExecutor.setClusterService((ClusterService)params.get(CLUSTER_SERVICE));
            this.connectorExecutor.setClient((ReleasableSkyliteClient)((Client)params.get(CLIENT)));
            this.connectorExecutor.setXContentRegistry((NamedXContentRegistry)params.get(XCONTENT_REGISTRY));
            this.connectorExecutor.setRateLimiter((TokenBucket)params.get(RATE_LIMITER));
            this.connectorExecutor.setUserRateLimiterMap((Map)params.get(USER_RATE_LIMITER_MAP));
            this.connectorExecutor.setMlGuard((MLGuard)params.get(GUARDRAILS));
            this.connectorExecutor.setConnectorPrivateIpEnabled((AtomicBoolean)params.get(CONNECTOR_PRIVATE_IP_ENABLED));
        }
        catch (RuntimeException e) {
            log.error("Failed to init remote model.", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            log.error("Failed to init remote model.", e);
            throw new MLException(e);
        }
    }
}

