/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.rest;

import io.lucenia.ml.common.rest.MLRestHandler;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.transport.batch.MLBatchIngestionAction;
import io.skylite.ml.common.transport.batch.MLBatchIngestionInput;
import io.skylite.ml.common.transport.batch.MLBatchIngestionRequest;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestMLBatchIngestAction
extends MLRestHandler {
    private static final Logger log = LogManager.getLogger(RestMLBatchIngestAction.class);
    private static final String ML_BATCH_INGESTION_ACTION = "ml_batch_ingestion_action";

    public String getName() {
        return ML_BATCH_INGESTION_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/_batch_ingestion", "/_plugins/_ml")));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MLBatchIngestionRequest mlBatchIngestTaskRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)MLBatchIngestionAction.INSTANCE, (ActionRequest)mlBatchIngestTaskRequest, (ActionListener)new RestToXContentListener(channel));
    }

    MLBatchIngestionRequest getRequest(RestRequest request) throws IOException {
        if (!request.hasContent()) {
            throw new IOException("Batch Ingestion request has empty body");
        }
        XContentParser parser = request.contentParser();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        MLBatchIngestionInput mlBatchIngestionInput = MLBatchIngestionInput.parse((XContentParser)parser);
        return new MLBatchIngestionRequest(mlBatchIngestionInput);
    }
}

