/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.rest;

import io.lucenia.ml.common.rest.MLRestHandler;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.cluster.TenantAwareHelper;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import io.skylite.ml.common.transport.connector.MLCreateConnectorAction;
import io.skylite.ml.common.transport.connector.MLCreateConnectorInput;
import io.skylite.ml.common.transport.connector.MLCreateConnectorRequest;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestMLCreateConnectorAction
extends MLRestHandler {
    private static final String ML_CREATE_CONNECTOR_ACTION = "ml_create_connector_action";
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public RestMLCreateConnectorAction(MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public String getName() {
        return ML_CREATE_CONNECTOR_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/connectors/_create", "/_plugins/_ml")));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MLCreateConnectorRequest mlCreateConnectorRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)MLCreateConnectorAction.INSTANCE, (ActionRequest)mlCreateConnectorRequest, (ActionListener)new RestToXContentListener(channel));
    }

    MLCreateConnectorRequest getRequest(RestRequest request) throws IOException {
        if (!this.mlFeatureEnabledSetting.isRemoteInferenceEnabled()) {
            throw new IllegalStateException("Remote Inference is currently disabled. To enable it, update the setting \"plugins.ml_commons.remote_inference_enabled\" to true.");
        }
        if (!request.hasContent()) {
            throw new IOException("Create Connector request has empty body");
        }
        XContentParser parser = request.contentParser();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        MLCreateConnectorInput mlCreateConnectorInput = MLCreateConnectorInput.parse((XContentParser)parser);
        String tenantId = TenantAwareHelper.getTenantID((Boolean)this.mlFeatureEnabledSetting.isMultiTenancyEnabled(), (RestRequest)request);
        mlCreateConnectorInput.setTenantId(tenantId);
        return new MLCreateConnectorRequest(mlCreateConnectorInput);
    }
}

